"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChromiumArchivePaths = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _path = _interopRequireDefault(require("path"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
var BaseUrl = /*#__PURE__*/function (BaseUrl) {
  BaseUrl["custom"] = "https://storage.googleapis.com/headless_shell";
  BaseUrl["chromeForTesting"] = "https://storage.googleapis.com/chrome-for-testing-public";
  return BaseUrl;
}(BaseUrl || {});
function isChromeForTestingPackage(p) {
  return p.location === 'chromeForTesting';
}
class ChromiumArchivePaths {
  constructor() {
    (0, _defineProperty2.default)(this, "packages", [{
      platform: 'darwin',
      architecture: 'x64',
      archiveFilename: 'chrome-headless-shell-mac-x64.zip',
      archiveChecksum: 'c496db22f4eefad91592f6f0d7585c519c333d210a5c674588606c00d2971ff4',
      binaryChecksum: '80625dfad8d14686a30eec8f3ff1f955ff77727ed5d89ae6c6fd0630e20cdf18',
      binaryRelativePath: 'chrome-headless-shell-mac-x64/chrome-headless-shell',
      version: '139.0.7258.138',
      location: 'chromeForTesting',
      archivePath: 'mac-x64',
      isPreInstalled: false
    }, {
      platform: 'darwin',
      architecture: 'arm64',
      archiveFilename: 'chrome-headless-shell-mac-arm64.zip',
      archiveChecksum: '35f8591f2c1ca5355f9678ee19e41c89538050ba837e103526b755dddaa46f03',
      binaryChecksum: '1bf659250fffb2a6f30ffb333dee97c56b73199f3a096d114e3216f0aa8d7b1b',
      binaryRelativePath: 'chrome-headless-shell-mac-arm64/chrome-headless-shell',
      version: '139.0.7258.138',
      location: 'chromeForTesting',
      archivePath: 'mac-arm64',
      isPreInstalled: false
    }, {
      platform: 'linux',
      architecture: 'x64',
      archiveFilename: 'chromium-884e54e-locales-linux_x64.zip',
      archiveChecksum: 'edb7e562b18c2f7068cec3740db53a3f73653ae89cf11d5bb2c9342c1470fb77',
      binaryChecksum: 'c3d984027aa2884b83e05fec11acb6689588099726ab1812736d790290d2662e',
      binaryRelativePath: 'headless_shell-linux_x64/headless_shell',
      location: 'custom',
      isPreInstalled: true
    }, {
      platform: 'linux',
      architecture: 'arm64',
      archiveFilename: 'chromium-884e54e-locales-linux_arm64.zip',
      archiveChecksum: 'ab789c4e89a43ba65c96d89f3c551d24fca98517741d9e22fe0d01cc5e18f9af',
      binaryChecksum: 'ba0170a64d0f9afa6fca3dca14724f4c203f9bffdfeb72d39df0f94ae26dae75',
      binaryRelativePath: 'headless_shell-linux_arm64/headless_shell',
      location: 'custom',
      isPreInstalled: true
    }, {
      platform: 'win32',
      architecture: 'x64',
      archiveFilename: 'chrome-headless-shell-win64.zip',
      archiveChecksum: '89264cca25daeeaf2c10aa8e2a7955407583398db05b69b2c5b0424e33ea2756',
      binaryChecksum: 'bf6ec35bbe45d040d1dd9e29fe1b2febf1036bd9e07030ab4ea5805f663f68cc',
      binaryRelativePath: _path.default.join('chrome-headless-shell-win64', 'chrome-headless-shell.exe'),
      version: '139.0.7258.138',
      location: 'chromeForTesting',
      archivePath: 'win64',
      isPreInstalled: true
    }]);
    // zip files get downloaded to a .chromium directory in the kibana root
    (0, _defineProperty2.default)(this, "archivesPath", _path.default.resolve(__dirname, '../../../../../../.chromium'));
  }
  find(platform, architecture, packages = this.packages) {
    return packages.find(p => p.platform === platform && p.architecture === architecture);
  }
  resolvePath(p) {
    // adding architecture to the path allows it to download two binaries that have the same name, but are different architecture
    return _path.default.resolve(this.archivesPath, p.architecture, p.archiveFilename);
  }
  getAllArchiveFilenames() {
    return this.packages.map(p => this.resolvePath(p));
  }
  getDownloadUrl(p) {
    if (isChromeForTestingPackage(p)) {
      const {
        chromeForTesting
      } = BaseUrl;
      const {
        archivePath,
        version,
        archiveFilename
      } = p;
      // returned string matches download value found at the following endpoint;
      // https://googlechromelabs.github.io/chrome-for-testing/known-good-versions-with-downloads.json
      return `${chromeForTesting}/${version}/${archivePath}/${archiveFilename}`;
    }
    return BaseUrl.custom + '/' + p.archiveFilename; // revision is not used for URL if package is a custom build
  }
  getBinaryPath(p, chromiumPath) {
    return _path.default.join(chromiumPath, p.binaryRelativePath);
  }
}
exports.ChromiumArchivePaths = ChromiumArchivePaths;