"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSavedSearch = void 0;
var _common = require("@kbn/data-plugin/common");
var _common2 = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getSavedSearch = async (savedSearchId, deps) => {
  var _savedSearch$attribut, _savedSearch$attribut2;
  const savedSearch = await deps.savedObjects.get('search', savedSearchId);
  const parsedSearchSourceJSON = (0, _common.parseSearchSourceJSON)((_savedSearch$attribut = (_savedSearch$attribut2 = savedSearch.attributes.kibanaSavedObjectMeta) === null || _savedSearch$attribut2 === void 0 ? void 0 : _savedSearch$attribut2.searchSourceJSON) !== null && _savedSearch$attribut !== void 0 ? _savedSearch$attribut : '{}');
  const searchSourceValues = (0, _common.injectReferences)(parsedSearchSourceJSON, savedSearch.references);
  return (0, _common2.fromSavedSearchAttributes)(savedSearchId, savedSearch.attributes, undefined, await deps.searchSourceStart.create(searchSourceValues), Boolean(savedSearch.managed));
};
exports.getSavedSearch = getSavedSearch;