"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkForDuplicateTitle = void 0;
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const hasDuplicatedTitle = async (title, contentManagement) => {
  if (!title) {
    return;
  }
  const response = await contentManagement.search({
    contentTypeId: _constants.SAVED_SEARCH_TYPE,
    query: {
      text: `"${title}"`
    },
    options: {
      searchFields: ['title'],
      fields: ['title']
    }
  });
  return response.hits.some(obj => obj.attributes.title.toLowerCase() === title.toLowerCase());
};
const checkForDuplicateTitle = async ({
  title,
  isTitleDuplicateConfirmed,
  onTitleDuplicate,
  contentManagement
}) => {
  if (title && !isTitleDuplicateConfirmed && onTitleDuplicate && (await hasDuplicatedTitle(title, contentManagement))) {
    onTitleDuplicate();
    return Promise.reject(new Error(`Saved Discover session title already exists: ${title}`));
  }
  return;
};
exports.checkForDuplicateTitle = checkForDuplicateTitle;