"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBulkActions = void 0;
var _bulk_delete = require("./bulk_delete");
var _bulk_assign = require("./bulk_assign");
var _clear_selection = require("./clear_selection");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getBulkActions = ({
  startServices,
  capabilities,
  tagClient,
  tagCache,
  assignmentService,
  clearSelection,
  setLoading,
  assignableTypes
}) => {
  const actions = [];
  if (capabilities.assign && assignableTypes.length > 0) {
    actions.push((0, _bulk_assign.getBulkAssignAction)({
      ...startServices,
      tagCache,
      assignmentService,
      assignableTypes,
      setLoading
    }));
  }
  if (capabilities.delete) {
    actions.push((0, _bulk_delete.getBulkDeleteAction)({
      ...startServices,
      tagClient,
      setLoading
    }));
  }

  // only add clear selection if user has permission to perform any other action
  // as having at least one action will show the bulk action menu, and the selection column on the table
  // and we want to avoid doing that only for the 'unselect' action.
  if (actions.length > 0) {
    actions.push((0, _clear_selection.getClearSelectionAction)({
      clearSelection
    }));
  }
  return actions;
};
exports.getBulkActions = getBulkActions;