"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateJob = updateJob;
var _action_types = require("../action_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  isUpdating: false,
  error: undefined
};
function updateJob(state = initialState, action) {
  const {
    type
  } = action;
  switch (type) {
    case _action_types.UPDATE_JOB_START:
      return {
        isUpdating: true
      };
    case _action_types.UPDATE_JOB_SUCCESS:
      return {
        isUpdating: false
      };
    case _action_types.UPDATE_JOB_FAILURE:
      return {
        isUpdating: false
      };
    default:
      return state;
  }
}