"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobActionMenu = void 0;
var _reactRedux = require("react-redux");
var _selectors = require("../../../store/selectors");
var _actions = require("../../../store/actions");
var _job_action_menu = require("./job_action_menu");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapStateToProps = state => {
  return {
    isUpdating: (0, _selectors.isUpdating)(state)
  };
};
const mapDispatchToProps = (dispatch, {
  jobs
}) => {
  const jobIds = jobs.map(job => job.id);
  return {
    startJobs: () => {
      dispatch((0, _actions.startJobs)(jobIds));
    },
    stopJobs: () => {
      dispatch((0, _actions.stopJobs)(jobIds));
    },
    deleteJobs: () => {
      dispatch((0, _actions.deleteJobs)(jobIds));
    },
    cloneJob: jobConfig => {
      dispatch((0, _actions.cloneJob)(jobConfig));
    }
  };
};
const JobActionMenu = exports.JobActionMenu = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_job_action_menu.JobActionMenu);