"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldList = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FieldList = ({
  columns,
  fields,
  onRemoveField,
  addButton,
  emptyMessage,
  dataTestSubj
}) => {
  let message;
  if (!fields.length) {
    message = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: emptyMessage,
      titleSize: "xs"
    });
  }
  let extendedColumns;
  if (onRemoveField) {
    extendedColumns = columns.concat({
      name: 'Remove',
      width: '80px',
      actions: [{
        name: 'Remove',
        isPrimary: true,
        description: 'Remove this field',
        icon: 'trash',
        type: 'icon',
        color: 'danger',
        onClick: field => onRemoveField(field)
      }]
    });
  } else {
    extendedColumns = columns;
  }
  const search = {
    toolsRight: addButton ? addButton : undefined,
    box: {
      incremental: true,
      placeholder: 'Search'
    }
  };
  const pagination = {
    initialPageSize: 200,
    pageSizeOptions: [20, 100, 200]
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: fields,
    itemId: "name",
    columns: extendedColumns,
    search: search,
    pagination: pagination,
    sorting: true,
    message: message,
    "data-test-subj": dataTestSubj
  });
};
exports.FieldList = FieldList;
FieldList.propTypes = {
  columns: _propTypes.default.array.isRequired,
  fields: _propTypes.default.array.isRequired,
  onRemoveField: _propTypes.default.func,
  addButton: _propTypes.default.node,
  emptyMessage: _propTypes.default.node,
  dataTestSubj: _propTypes.default.string
};