"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transactionDurationParamsSchema = exports.AggregationType = void 0;
var _configSchema = require("@kbn/config-schema");
var _search_configuration_schema = require("../common/search_configuration_schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
let AggregationType = exports.AggregationType = /*#__PURE__*/function (AggregationType) {
  AggregationType["Avg"] = "avg";
  AggregationType["P95"] = "95th";
  AggregationType["P99"] = "99th";
  return AggregationType;
}({});
const transactionDurationParamsSchema = exports.transactionDurationParamsSchema = _configSchema.schema.object({
  serviceName: _configSchema.schema.maybe(_configSchema.schema.string()),
  transactionType: _configSchema.schema.maybe(_configSchema.schema.string()),
  transactionName: _configSchema.schema.maybe(_configSchema.schema.string()),
  windowSize: _configSchema.schema.number(),
  windowUnit: _configSchema.schema.string(),
  threshold: _configSchema.schema.number(),
  aggregationType: _configSchema.schema.oneOf([_configSchema.schema.literal(AggregationType.Avg), _configSchema.schema.literal(AggregationType.P95), _configSchema.schema.literal(AggregationType.P99)]),
  environment: _configSchema.schema.string(),
  groupBy: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  useKqlFilter: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  searchConfiguration: _configSchema.schema.maybe(_search_configuration_schema.searchConfigurationSchema)
});