"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerGenerationRoutesInternal = registerGenerationRoutesInternal;
var _coreHttpRouterServerInternal = require("@kbn/core-http-router-server-internal");
var _reportingCommon = require("@kbn/reporting-common");
var _common = require("../../common");
var _request_handler = require("../../common/request_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  GENERATE_PREFIX
} = _reportingCommon.INTERNAL_ROUTES;
function registerGenerationRoutesInternal(reporting, logger) {
  const setupDeps = reporting.getPluginSetupDeps();
  const {
    router
  } = setupDeps;
  const useKibanaAccessControl = reporting.getDeprecatedAllowedRoles() === false; // true if Reporting's deprecated access control feature is disabled
  const kibanaAccessControlTags = useKibanaAccessControl ? ['generateReport'] : [];
  const registerInternalPostGenerationEndpoint = () => {
    const path = `${GENERATE_PREFIX}/{exportType}`;
    router.post({
      path,
      security: {
        authz: {
          ...(kibanaAccessControlTags.length ? {
            requiredPrivileges: kibanaAccessControlTags
          } : {
            enabled: false,
            reason: 'This route is opted out from authorization because of the kibana access control flag'
          })
        }
      },
      validate: _request_handler.GenerateRequestHandler.getValidation(),
      options: {
        tags: kibanaAccessControlTags.map(accessControlTag => `access:${accessControlTag}`),
        access: 'internal'
      }
    }, (0, _common.authorizedUserPreRouting)(reporting, async (user, context, req, res) => {
      try {
        const requestHandler = new _request_handler.GenerateRequestHandler({
          reporting,
          user,
          context,
          path,
          req,
          res,
          logger
        });
        const jobParams = requestHandler.getJobParams();
        return await requestHandler.handleRequest({
          exportTypeId: req.params.exportType,
          jobParams
        });
      } catch (err) {
        if (err instanceof _coreHttpRouterServerInternal.KibanaResponse) {
          return err;
        }
        throw err;
      }
    }));
  };
  registerInternalPostGenerationEndpoint();
}