"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetUserProfileQuery = exports.getKey = void 0;
var _reactQuery = require("@tanstack/react-query");
var _query_keys = require("../query_keys");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getKey = exports.getKey = _query_keys.queryKeys.getUserProfile;
const useGetUserProfileQuery = ({
  userProfileService
}) => {
  return (0, _reactQuery.useQuery)({
    queryKey: getKey(),
    queryFn: () => userProfileService.getCurrent(),
    enabled: Boolean(userProfileService)
  });
};
exports.useGetUserProfileQuery = useGetUserProfileQuery;