"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailPanel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../../../common/constants");
var _components = require("../../components");
var _components2 = require("../components");
var _services = require("../../../services");
var _documentation = require("../../../services/documentation");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DetailPanel extends _react.Component {
  renderSkipUnavailableValue(skipUnavailable) {
    if (skipUnavailable === true) {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.detailPanel.skipUnavailableTrueValue",
        defaultMessage: "Yes"
      });
    }
    if (skipUnavailable === false) {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.detailPanel.skipUnavailableFalseValue",
        defaultMessage: "No"
      });
    }
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.detailPanel.skipUnavailableNullValue",
      defaultMessage: "Default"
    });
  }
  renderClusterNotFound() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexStart",
      alignItems: "center",
      gutterSize: "s",
      "data-test-subj": "remoteClusterDetailClusterNotFound"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "m",
      type: "warning",
      color: "danger"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.detailPanel.notFoundLabel",
      defaultMessage: "Remote cluster not found"
    })))));
  }
  renderClusterConfiguredByNodeWarning({
    isConfiguredByNode
  }) {
    if (!isConfiguredByNode) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_components.ConfiguredByNodeWarning, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }));
  }
  renderClusterWithDeprecatedSettingWarning({
    hasDeprecatedProxySetting,
    isConfiguredByNode
  }, clusterName, history) {
    if (!hasDeprecatedProxySetting) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.detailPanel.deprecatedSettingsTitle",
        defaultMessage: "''{remoteCluster}'' has deprecated settings",
        values: {
          remoteCluster: clusterName
        }
      }),
      color: "warning",
      iconType: "question"
    }, isConfiguredByNode ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.detailPanel.deprecatedSettingsConfiguredByNodeMessage",
      defaultMessage: "Edit the cluster to update the settings. {helpLink}",
      values: {
        helpLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _documentation.proxyModeUrl,
          target: "_blank"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.remoteClusters.detailPanel.deprecatedSettingsLearnMoreLinkLabel",
          defaultMessage: "Learn more."
        }))
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.detailPanel.deprecatedSettingsMessage",
      defaultMessage: "{editLink} to update the settings.",
      values: {
        editLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _public.reactRouterNavigate)(history, `/edit/${clusterName}`), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.remoteClusters.detailPanel.deprecatedSettingsEditLinkLabel",
          defaultMessage: "Edit the cluster"
        }))
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }));
  }
  renderSniffModeDescriptionList({
    isConnected,
    connectedNodesCount,
    skipUnavailable,
    seeds,
    maxConnectionsPerCluster,
    nodeConnections,
    initialConnectTimeout,
    mode,
    securityModel
  }) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      "data-test-subj": "remoteClusterDetailPanelStatusValues"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.detailPanel.connectedLabel",
      defaultMessage: "Connection"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "remoteClusterDetailIsConnected"
    }, /*#__PURE__*/_react.default.createElement(_components2.ConnectionStatus, {
      isConnected: isConnected,
      mode: mode
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.detailPanel.securityModel",
      defaultMessage: "Authentication type"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "remoteClusterDetailAuthType"
    }, /*#__PURE__*/_react.default.createElement(_components2.SecurityModel, {
      securityModel: securityModel
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.detailPanel.connectedNodesLabel",
      defaultMessage: "Connected nodes"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "remoteClusterDetailConnectedNodesCount"
    }, connectedNodesCount), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.detailPanel.seedsLabel",
      defaultMessage: "Seeds"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "remoteClusterDetailSeeds"
    }, seeds.map(seed => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      key: seed
    }, seed))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.detailPanel.skipUnavailableLabel",
      defaultMessage: "Skip unavailable"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "remoteClusterDetailSkipUnavailable"
    }, this.renderSkipUnavailableValue(skipUnavailable)), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.detailPanel.nodeConnectionsLabel",
      defaultMessage: "Node connections"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "remoteClusterDetailNodeConnections"
    }, nodeConnections || '-'), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.detailPanel.maxConnectionsPerClusterLabel",
      defaultMessage: "Maximum connections"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "remoteClusterDetailMaxConnections"
    }, maxConnectionsPerCluster), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.detailPanel.initialConnectTimeoutLabel",
      defaultMessage: "Initial connect timeout"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "remoteClusterDetailInitialConnectTimeout"
    }, initialConnectTimeout))));
  }
  renderProxyModeDescriptionList({
    isConnected,
    skipUnavailable,
    initialConnectTimeout,
    proxyAddress,
    proxySocketConnections,
    maxProxySocketConnections,
    connectedSocketsCount,
    mode,
    serverName,
    securityModel
  }) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.detailPanel.connectedLabel",
      defaultMessage: "Connection"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "remoteClusterDetailIsConnected"
    }, /*#__PURE__*/_react.default.createElement(_components2.ConnectionStatus, {
      isConnected: isConnected,
      mode: mode
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.detailPanel.securityModel",
      defaultMessage: "Authentication type"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "remoteClusterDetailAuthType"
    }, /*#__PURE__*/_react.default.createElement(_components2.SecurityModel, {
      securityModel: securityModel
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.detailPanel.connectedSocketsLabel",
      defaultMessage: "Connected sockets"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "remoteClusterDetailConnectedSocketsCount"
    }, connectedSocketsCount ? connectedSocketsCount : '-'), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.detailPanel.proxyAddressLabel",
      defaultMessage: "Proxy address"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "remoteClusterDetailProxyAddress"
    }, proxyAddress), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.detailPanel.serverNameLabel",
      defaultMessage: "Server name"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "remoteClusterDetailServerName"
    }, serverName ? serverName : '-'))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.detailPanel.skipUnavailableLabel",
      defaultMessage: "Skip unavailable"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "remoteClusterDetailSkipUnavailable"
    }, this.renderSkipUnavailableValue(skipUnavailable)), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.detailPanel.proxySocketConnectionsLabel",
      defaultMessage: "Proxy socket connections"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "remoteClusterDetailProxySocketConnections"
    }, proxySocketConnections || '-'), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.detailPanel.maxSocketConnectionsLabel",
      defaultMessage: "Maximum socket connections"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "remoteClusterDetailMaxSocketConnections"
    }, maxProxySocketConnections || '-'), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.detailPanel.initialConnectTimeoutLabel",
      defaultMessage: "Initial connect timeout"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      "data-test-subj": "remoteClusterDetailInitialConnectTimeout"
    }, initialConnectTimeout))));
  }
  renderCluster(cluster) {
    return /*#__PURE__*/_react.default.createElement("section", {
      "aria-labelledby": "clusterStatus",
      "data-test-subj": "remoteClusterDetailPanelStatusSection"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      id: "clusterStatus"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.detailPanel.statusTitle",
      defaultMessage: "Status"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), cluster.mode === _constants.PROXY_MODE ? this.renderProxyModeDescriptionList(cluster) : this.renderSniffModeDescriptionList(cluster));
  }
  renderFlyoutBody(history) {
    const {
      cluster,
      clusterName
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, !cluster && this.renderClusterNotFound(), cluster && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, this.renderClusterConfiguredByNodeWarning(cluster), this.renderClusterWithDeprecatedSettingWarning(cluster, clusterName, history), this.renderCluster(cluster)));
  }
  renderFlyoutFooter(history) {
    const {
      cluster,
      clusterName,
      closeDetailPanel
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "cross",
      flush: "left",
      onClick: closeDetailPanel,
      "data-test-subj": "remoteClusterDetailsPanelCloseButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.detailPanel.closeButtonLabel",
      defaultMessage: "Close"
    }))), cluster && !cluster.isConfiguredByNode && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_components2.RemoveClusterButtonProvider, {
      clusterNames: [clusterName]
    }, removeCluster => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      color: "danger",
      onClick: removeCluster,
      "data-test-subj": "remoteClusterDetailPanelRemoveButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.detailPanel.removeButtonLabel",
      defaultMessage: "Remove"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(history, `/edit/${clusterName}`), {
      fill: true,
      color: "primary",
      "data-test-subj": "remoteClusterDetailPanelEditButton"
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.detailPanel.editButtonLabel",
      defaultMessage: "Edit"
    })))))));
  }
  render() {
    const {
      isOpen,
      closeDetailPanel,
      clusterName,
      cluster
    } = this.props;
    const {
      history
    } = (0, _services.getRouter)();
    if (!isOpen) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
      "data-test-subj": "remoteClusterDetailFlyout",
      onClose: closeDetailPanel,
      "aria-labelledby": "remoteClusterDetailsFlyoutTitle",
      size: "m",
      maxWidth: 550,
      className: "eui-textBreakAll"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m",
      id: "remoteClusterDetailsFlyoutTitle",
      "data-test-subj": "remoteClusterDetailsFlyoutTitle"
    }, /*#__PURE__*/_react.default.createElement("h2", null, clusterName))), cluster && cluster.mode === _constants.PROXY_MODE ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      title: _i18n.i18n.translate('xpack.remoteClusters.detailPanel.proxyBadgeLabel', {
        defaultMessage: `This remote cluster was configured with the "proxy" connection mode`
      })
    }, cluster.mode)) : null)), this.renderFlyoutBody(history), this.renderFlyoutFooter(history));
  }
}
exports.DetailPanel = DetailPanel;
(0, _defineProperty2.default)(DetailPanel, "propTypes", {
  isOpen: _propTypes.default.bool.isRequired,
  isLoading: _propTypes.default.bool,
  cluster: _propTypes.default.object,
  closeDetailPanel: _propTypes.default.func.isRequired,
  clusterName: _propTypes.default.string
});