"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectionStatus = ConnectionStatus;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ConnectionStatus({
  isConnected,
  mode
}) {
  const seedNodeTooltip = _i18n.i18n.translate('xpack.remoteClusters.connectedStatus.notConnectedToolTip', {
    defaultMessage: `Ensure the seed nodes are configured with the remote cluster's transport port, not the http port.`
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: isConnected ? 'success' : 'danger',
    "data-test-subj": "remoteClusterConnectionStatusMessage"
  }, isConnected ? _i18n.i18n.translate('xpack.remoteClusters.connectedStatus.connectedAriaLabel', {
    defaultMessage: 'Connected'
  }) : _i18n.i18n.translate('xpack.remoteClusters.connectedStatus.notConnectedAriaLabel', {
    defaultMessage: 'Not connected'
  }))), !isConnected && mode === _constants.SNIFF_MODE && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    color: "subdued",
    content: seedNodeTooltip
  })));
}
ConnectionStatus.propTypes = {
  isConnected: _propTypes.default.bool,
  mode: _propTypes.default.oneOf([_constants.SNIFF_MODE, _constants.PROXY_MODE])
};