"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupCloud = setupCloud;
var _cluster_settings = require("../../lib/setup/cluster_settings");
var _fleet_policies = require("../../lib/setup/fleet_policies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function setupCloud({
  setupState,
  setupParams
}) {
  const executeAdminFunctions = [...(setupState.resource_management.enabled ? [] : [_cluster_settings.enableResourceManagement]), ...(setupState.settings.configured ? [] : [_cluster_settings.setMaximumBuckets])];
  const executeViewerFunctions = [...(setupState.policies.collector.installed ? [] : [_fleet_policies.createCollectorPackagePolicy]), ...(setupState.policies.symbolizer.installed ? [] : [_fleet_policies.createSymbolizerPackagePolicy]), ...(setupState.policies.apm.profilingEnabled ? [_fleet_policies.removeProfilingFromApmPackagePolicy] : [])];
  // Give priority to admin functions as if something fails we won't procceed to viewer functions
  await Promise.all(executeAdminFunctions.map(fn => fn(setupParams)));
  await Promise.all(executeViewerFunctions.map(fn => fn(setupParams)));
}