"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RouteBreadcrumb = void 0;
var _use_profiling_dependencies = require("../components/contexts/profiling_dependencies/use_profiling_dependencies");
var _use_route_breadcrumb = require("../components/contexts/route_breadcrumbs_context/use_route_breadcrumb");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RouteBreadcrumb = ({
  title,
  href,
  children
}) => {
  const {
    start: {
      core
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  (0, _use_route_breadcrumb.useRouteBreadcrumb)({
    title,
    href: core.http.basePath.prepend('/app/profiling/' + href)
  });
  return children;
};
exports.RouteBreadcrumb = RouteBreadcrumb;