"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableSearchBar = EmbeddableSearchBar;
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _profiling_search_bar = require("../../components/profiling_app_page_template/profiling_search_bar");
var _profiling_embeddable_provider = require("../profiling_embeddable_provider");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EmbeddableSearchBar({
  showDatePicker,
  kuery,
  onQuerySubmit,
  onRefresh,
  rangeFrom,
  rangeTo,
  ...deps
}) {
  return /*#__PURE__*/_react2.default.createElement(_profiling_embeddable_provider.ProfilingEmbeddableProvider, {
    deps: deps
  }, /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
          width: 100%;
        `
  }, /*#__PURE__*/_react2.default.createElement(_profiling_search_bar.ProfilingSearchBar, {
    showDatePicker: showDatePicker !== null && showDatePicker !== void 0 ? showDatePicker : true,
    showSubmitButton: true,
    kuery: kuery,
    onQuerySubmit: ({
      dateRange,
      query
    }) => {
      onQuerySubmit({
        dateRange,
        query: typeof (query === null || query === void 0 ? void 0 : query.query) === 'string' ? query.query : ''
      });
    },
    onRefresh: onRefresh,
    onRefreshClick: onRefresh,
    showQueryMenu: false,
    rangeFrom: rangeFrom,
    rangeTo: rangeTo
  })));
}