"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.FieldPicker = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _classnames = _interopRequireDefault(require("classnames"));
var _lodash = require("lodash");
var _fieldUtils = require("@kbn/field-utils");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _reactField = require("@kbn/react-field");
var _eui = require("@elastic/eui");
var _field_type_filter = require("./field_type_filter");
require("./field_picker.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const FieldPicker = ({
  dataView,
  onSelectField,
  filterPredicate,
  selectedFieldName,
  selectableProps,
  ...other
}) => {
  const initialSelection = (0, _react.useRef)(selectedFieldName);
  const [typesFilter, setTypesFilter] = (0, _react.useState)([]);
  const [searchRef, setSearchRef] = (0, _react.useState)(null);
  const [fieldSelectableOptions, setFieldSelectableOptions] = (0, _react.useState)([]);
  const availableFields = (0, _react.useMemo)(() => {
    var _dataView$fields;
    return (0, _lodash.sortBy)(((_dataView$fields = dataView === null || dataView === void 0 ? void 0 : dataView.fields) !== null && _dataView$fields !== void 0 ? _dataView$fields : []).filter(f => typesFilter.length === 0 || typesFilter.includes((0, _fieldUtils.getFieldIconType)(f))).filter(f => filterPredicate ? filterPredicate(f) : true), ['name']).sort(f => f.name === initialSelection.current ? -1 : 1);
  }, [dataView, filterPredicate, typesFilter]);
  (0, _react.useEffect)(() => {
    if (!dataView) return;
    const options = (availableFields !== null && availableFields !== void 0 ? availableFields : []).map(field => {
      var _field$displayName;
      return {
        key: field.name,
        name: field.name,
        label: (_field$displayName = field.displayName) !== null && _field$displayName !== void 0 ? _field$displayName : field.name,
        className: 'presFieldPicker__fieldButton',
        checked: field.name === selectedFieldName ? 'on' : undefined,
        'data-test-subj': `field-picker-select-${field.name}`,
        prepend: /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, {
          type: (0, _fieldUtils.getFieldIconType)(field),
          label: field.name,
          scripted: field.scripted,
          className: "eui-alignMiddle"
        })
      };
    });
    setFieldSelectableOptions(options);
  }, [availableFields, dataView, filterPredicate, selectedFieldName, typesFilter]);
  const uniqueTypes = (0, _react.useMemo)(() => dataView ? (0, _lodash.uniq)(dataView.fields.filter(f => filterPredicate ? filterPredicate(f) : true).map(f => (0, _fieldUtils.getFieldIconType)(f))) : [], [dataView, filterPredicate]);
  const setFocusToSearch = (0, _react.useCallback)(() => {
    searchRef === null || searchRef === void 0 ? void 0 : searchRef.focus();
  }, [searchRef]);
  const fieldTypeFilter = /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_field_type_filter.FieldTypeFilter, {
    setFocusToSearch: setFocusToSearch,
    onFieldTypesChange: types => setTypesFilter(types),
    fieldTypesValue: typesFilter,
    availableFieldTypes: uniqueTypes,
    buttonProps: {
      disabled: Boolean(selectableProps === null || selectableProps === void 0 ? void 0 : selectableProps.isLoading)
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, (0, _extends2.default)({}, other, selectableProps, {
    className: (0, _classnames.default)('fieldPickerSelectable', {
      fieldPickerSelectableLoading: selectableProps === null || selectableProps === void 0 ? void 0 : selectableProps.isLoading
    }),
    emptyMessage: _i18n.i18n.translate('presentationUtil.fieldPicker.noFieldsLabel', {
      defaultMessage: 'No matching fields'
    }),
    "aria-label": _i18n.i18n.translate('presentationUtil.fieldPicker.selectableAriaLabel', {
      defaultMessage: 'Select a field'
    }),
    searchable: true,
    options: fieldSelectableOptions,
    onChange: (options, _, changedOption) => {
      setFieldSelectableOptions(options);
      if (!dataView || !changedOption.key) return;
      const field = dataView.getFieldByName(changedOption.key);
      if (field) onSelectField === null || onSelectField === void 0 ? void 0 : onSelectField(field);
    },
    optionMatcher: _fieldUtils.comboBoxFieldOptionMatcher,
    searchProps: {
      'data-test-subj': 'field-search-input',
      placeholder: _i18n.i18n.translate('presentationUtil.fieldSearch.searchPlaceHolder', {
        defaultMessage: 'Search field names'
      }),
      compressed: true,
      disabled: Boolean(selectableProps === null || selectableProps === void 0 ? void 0 : selectableProps.isLoading),
      inputRef: setSearchRef
    },
    listProps: {
      isVirtualized: true,
      showIcons: false,
      bordered: true,
      truncationProps: {
        truncation: 'middle'
      }
    },
    height: "full"
  }), (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's'
  }), fieldTypeFilter, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's'
  }), list));
};

// required for dynamic import using React.lazy()
// eslint-disable-next-line import/no-default-export
exports.FieldPicker = FieldPicker;
var _default = exports.default = FieldPicker;