"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PresentationPanelInternal = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _panelLoader = require("@kbn/panel-loader");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _classnames = _interopRequireDefault(require("classnames"));
var _react2 = _interopRequireWildcard(require("react"));
var _presentation_panel_header = require("./panel_header/presentation_panel_header");
var _presentation_panel_hover_actions = require("./panel_header/presentation_panel_hover_actions");
var _presentation_panel_error_internal = require("./presentation_panel_error_internal");
var _use_panel_error_css = require("./use_panel_error_css");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const PresentationPanelInternal = ({
  index,
  hideHeader,
  showShadow,
  showBorder,
  showBadges,
  showNotifications,
  getActions,
  actionPredicate,
  Component,
  componentProps,
  setDragHandles
}) => {
  var _api$parentApi;
  const panelErrorCss = (0, _use_panel_error_css.usePanelErrorCss)();
  const [api, setApi] = (0, _react2.useState)(null);
  const headerId = (0, _react2.useMemo)(() => (0, _eui.htmlIdGenerator)()(), []);
  const dragHandles = (0, _react2.useRef)({});
  const viewModeSubject = (0, _react2.useMemo)(() => {
    if ((0, _presentationPublishing.apiPublishesViewMode)(api)) return api.viewMode$;
    if ((0, _presentationPublishing.apiHasParentApi)(api) && (0, _presentationPublishing.apiPublishesViewMode)(api.parentApi)) return api.parentApi.viewMode$;
  }, [api]);
  const [dataLoading, blockingError, panelTitle, hidePanelTitle, panelDescription, defaultPanelTitle, defaultPanelDescription, rawViewMode, parentHidePanelTitle] = (0, _presentationPublishing.useBatchedOptionalPublishingSubjects)(api === null || api === void 0 ? void 0 : api.dataLoading$, api === null || api === void 0 ? void 0 : api.blockingError$, api === null || api === void 0 ? void 0 : api.title$, api === null || api === void 0 ? void 0 : api.hideTitle$, api === null || api === void 0 ? void 0 : api.description$, api === null || api === void 0 ? void 0 : api.defaultTitle$, api === null || api === void 0 ? void 0 : api.defaultDescription$, viewModeSubject, api === null || api === void 0 ? void 0 : (_api$parentApi = api.parentApi) === null || _api$parentApi === void 0 ? void 0 : _api$parentApi.hideTitle$);
  const viewMode = rawViewMode !== null && rawViewMode !== void 0 ? rawViewMode : 'view';
  const [initialLoadComplete, setInitialLoadComplete] = (0, _react2.useState)(!dataLoading);
  if (!initialLoadComplete && (dataLoading === false || api && !api.dataLoading$)) {
    setInitialLoadComplete(true);
  }
  const hideTitle = Boolean(hidePanelTitle) || Boolean(parentHidePanelTitle) || !Boolean(panelTitle !== null && panelTitle !== void 0 ? panelTitle : defaultPanelTitle);
  const contentAttrs = (0, _react2.useMemo)(() => {
    const attrs = {};
    if (dataLoading) {
      attrs['data-loading'] = true;
    } else {
      attrs['data-render-complete'] = true;
    }
    if (blockingError) attrs['data-error'] = true;
    return attrs;
  }, [dataLoading, blockingError]);
  const setDragHandle = (0, _react2.useCallback)((id, ref) => {
    dragHandles.current[id] = ref;
    setDragHandles === null || setDragHandles === void 0 ? void 0 : setDragHandles(Object.values(dragHandles.current));
  }, [setDragHandles]);
  return /*#__PURE__*/_react2.default.createElement(_presentation_panel_hover_actions.PresentationPanelHoverActions, {
    index,
    api,
    getActions,
    actionPredicate,
    viewMode,
    showNotifications,
    showBorder,
    setDragHandle: setDragHandle
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, (0, _extends2.default)({
    role: "figure",
    paddingSize: "none",
    className: (0, _classnames.default)('embPanel', {
      'embPanel--editing': viewMode === 'edit'
    }),
    hasShadow: showShadow,
    "aria-labelledby": headerId,
    "data-test-subj": "embeddablePanel"
  }, contentAttrs, {
    css: styles.embPanel
  }), !hideHeader && api && /*#__PURE__*/_react2.default.createElement(_presentation_panel_header.PresentationPanelHeader, {
    api: api,
    setDragHandle: setDragHandle,
    headerId: headerId,
    viewMode: viewMode,
    hideTitle: hideTitle,
    showBadges: showBadges,
    getActions: getActions,
    showNotifications: showNotifications,
    panelTitle: panelTitle !== null && panelTitle !== void 0 ? panelTitle : defaultPanelTitle,
    panelDescription: panelDescription !== null && panelDescription !== void 0 ? panelDescription : defaultPanelDescription
  }), blockingError && api && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    css: panelErrorCss,
    className: "eui-fullHeight",
    "data-test-subj": "embeddableError",
    justifyContent: "center"
  }, /*#__PURE__*/_react2.default.createElement(_presentation_panel_error_internal.PresentationPanelErrorInternal, {
    api: api,
    error: blockingError
  })), !initialLoadComplete && /*#__PURE__*/_react2.default.createElement(_panelLoader.PanelLoader, null), /*#__PURE__*/_react2.default.createElement("div", {
    className: blockingError ? 'embPanel__content--hidden' : 'embPanel__content',
    css: styles.embPanelContent
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react2.default.createElement(Component, (0, _extends2.default)({}, componentProps, {
    ref: newApi => {
      if (newApi && !api) setApi(newApi);
    }
  }))))));
};

/**
 * if there is no reliance on EUI theme, then it is more performant to store styles as minimizable objects
 * outside of the React component so that it is not parsed on every render
 */
exports.PresentationPanelInternal = PresentationPanelInternal;
const styles = {
  embPanel: (0, _react.css)({
    zIndex: 'auto',
    flex: 1,
    display: 'flex',
    flexDirection: 'column',
    height: '100%',
    position: 'relative',
    overflow: 'hidden'
  }),
  embPanelContent: (0, _react.css)({
    '&.embPanel__content': {
      display: 'flex',
      flex: '1 1 100%',
      zIndex: 1,
      minHeight: 0,
      // Absolute must for Firefox to scroll contents
      overflow: 'hidden'
    },
    '&.embPanel__content--hidden, &[data-error]': {
      display: 'none'
    }
  })
};