"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = renderApp;
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _shared_imports = require("../shared_imports");
var _context = require("./context");
var _main = require("./components/main");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function renderApp(element, {
  http,
  uiSettings,
  links,
  chrome,
  settings,
  startServices
}) {
  if (!element) {
    return () => undefined;
  }
  const {
    Provider: KibanaReactContextProvider
  } = (0, _shared_imports.createKibanaReactContext)({
    uiSettings,
    settings
  });
  (0, _reactDom.render)(/*#__PURE__*/_react.default.createElement(_shared_imports.KibanaRenderContextProvider, startServices, /*#__PURE__*/_react.default.createElement(KibanaReactContextProvider, null, /*#__PURE__*/_react.default.createElement(_context.AppContextProvider, {
    value: {
      http,
      links,
      chrome
    }
  }, /*#__PURE__*/_react.default.createElement(_main.Main, null)))), element);
  return () => (0, _reactDom.unmountComponentAtNode)(element);
}