"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RequestFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RequestFlyout = ({
  onClose,
  requestBody,
  response,
  links
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    maxWidth: 640
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    "data-test-subj": "painlessLabRequestFlyoutHeader"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.painlessLab.flyoutTitle', {
    defaultMessage: 'API request'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    flush: "right",
    href: links.painlessExecuteAPI,
    target: "_blank",
    iconType: "question"
  }, _i18n.i18n.translate('xpack.painlessLab.flyoutDocLink', {
    defaultMessage: 'API documentation'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    size: "s",
    tabs: [{
      id: 'request',
      name: 'Request',
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        language: "json",
        paddingSize: "s",
        isCopyable: true
      }, 'POST _scripts/painless/_execute\n', requestBody)
    }, {
      id: 'response',
      name: 'Response',
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        language: "json",
        paddingSize: "s",
        isCopyable: true
      }, response)
    }]
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "painlessLabBottomBarPlaceholder"
  })));
};
exports.RequestFlyout = RequestFlyout;