"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SHORT_EMPTY_TITLE = exports.PERMISSION_DENIED = exports.NOT_AVAILABLE = exports.EMPTY_PROMPT = exports.AGENT_STATUS_ERROR = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SHORT_EMPTY_TITLE = exports.SHORT_EMPTY_TITLE = _i18n.i18n.translate('xpack.osquery.action.shortEmptyTitle', {
  defaultMessage: 'Osquery is not available'
});
const EMPTY_PROMPT = exports.EMPTY_PROMPT = _i18n.i18n.translate('xpack.osquery.action.empty', {
  defaultMessage: 'An Elastic Agent is not installed on this host. To run queries, install Elastic Agent on the host, and then add the Osquery Manager integration to the agent policy in Fleet.'
});
const PERMISSION_DENIED = exports.PERMISSION_DENIED = _i18n.i18n.translate('xpack.osquery.action.permissionDenied', {
  defaultMessage: 'Permission denied'
});
const NOT_AVAILABLE = exports.NOT_AVAILABLE = _i18n.i18n.translate('xpack.osquery.action.unavailable', {
  defaultMessage: 'The Osquery Manager integration is not added to the agent policy. To run queries on the host, add the Osquery Manager integration to the agent policy in Fleet.'
});
const AGENT_STATUS_ERROR = exports.AGENT_STATUS_ERROR = _i18n.i18n.translate('xpack.osquery.action.agentStatus', {
  defaultMessage: 'To run queries on this host, the Elastic Agent must be active. Check the status of this agent in Fleet.'
});