"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBreadcrumbs = useBreadcrumbs;
var _i18n = require("@kbn/i18n");
var _constants = require("../../../common/constants");
var _page_paths = require("../page_paths");
var _kibana = require("../lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BASE_BREADCRUMB = {
  href: _page_paths.pagePathGetters.overview(),
  text: _i18n.i18n.translate('xpack.osquery.breadcrumbs.appTitle', {
    defaultMessage: 'Osquery'
  })
};
const breadcrumbGetters = {
  base: () => [BASE_BREADCRUMB],
  overview: () => [BASE_BREADCRUMB, {
    text: _i18n.i18n.translate('xpack.osquery.breadcrumbs.overviewPageTitle', {
      defaultMessage: 'Overview'
    })
  }],
  live_queries: () => [BASE_BREADCRUMB, {
    text: _i18n.i18n.translate('xpack.osquery.breadcrumbs.liveQueriesPageTitle', {
      defaultMessage: 'Live queries'
    })
  }],
  live_query_new: () => [BASE_BREADCRUMB, {
    href: _page_paths.pagePathGetters.live_queries(),
    text: _i18n.i18n.translate('xpack.osquery.breadcrumbs.liveQueriesPageTitle', {
      defaultMessage: 'Live queries'
    })
  }, {
    text: _i18n.i18n.translate('xpack.osquery.breadcrumbs.newLiveQueryPageTitle', {
      defaultMessage: 'New'
    })
  }],
  live_query_details: ({
    liveQueryId
  }) => [BASE_BREADCRUMB, {
    href: _page_paths.pagePathGetters.live_queries(),
    text: _i18n.i18n.translate('xpack.osquery.breadcrumbs.liveQueriesPageTitle', {
      defaultMessage: 'Live queries'
    })
  }, {
    text: liveQueryId
  }],
  saved_queries: () => [BASE_BREADCRUMB, {
    text: _i18n.i18n.translate('xpack.osquery.breadcrumbs.savedQueriesPageTitle', {
      defaultMessage: 'Saved queries'
    })
  }],
  saved_query_new: () => [BASE_BREADCRUMB, {
    href: _page_paths.pagePathGetters.saved_queries(),
    text: _i18n.i18n.translate('xpack.osquery.breadcrumbs.savedQueriesPageTitle', {
      defaultMessage: 'Saved queries'
    })
  }, {
    text: _i18n.i18n.translate('xpack.osquery.breadcrumbs.newSavedQueryPageTitle', {
      defaultMessage: 'New'
    })
  }],
  saved_query_edit: ({
    savedQueryName
  }) => [BASE_BREADCRUMB, {
    href: _page_paths.pagePathGetters.saved_queries(),
    text: _i18n.i18n.translate('xpack.osquery.breadcrumbs.savedQueriesPageTitle', {
      defaultMessage: 'Saved queries'
    })
  }, {
    text: savedQueryName
  }],
  packs: () => [BASE_BREADCRUMB, {
    text: _i18n.i18n.translate('xpack.osquery.breadcrumbs.packsPageTitle', {
      defaultMessage: 'Packs'
    })
  }],
  pack_add: () => [BASE_BREADCRUMB, {
    href: _page_paths.pagePathGetters.packs(),
    text: _i18n.i18n.translate('xpack.osquery.breadcrumbs.packsPageTitle', {
      defaultMessage: 'Packs'
    })
  }, {
    text: _i18n.i18n.translate('xpack.osquery.breadcrumbs.addpacksPageTitle', {
      defaultMessage: 'Add'
    })
  }],
  pack_details: ({
    packName
  }) => [BASE_BREADCRUMB, {
    href: _page_paths.pagePathGetters.packs(),
    text: _i18n.i18n.translate('xpack.osquery.breadcrumbs.packsPageTitle', {
      defaultMessage: 'Packs'
    })
  }, {
    text: packName
  }],
  pack_edit: ({
    packName,
    packId
  }) => [BASE_BREADCRUMB, {
    href: _page_paths.pagePathGetters.packs(),
    text: _i18n.i18n.translate('xpack.osquery.breadcrumbs.packsPageTitle', {
      defaultMessage: 'Packs'
    })
  }, {
    href: _page_paths.pagePathGetters.pack_details({
      packId
    }),
    text: packName
  }, {
    text: _i18n.i18n.translate('xpack.osquery.breadcrumbs.editpacksPageTitle', {
      defaultMessage: 'Edit'
    })
  }]
};
function useBreadcrumbs(page, values = {}) {
  var _breadcrumbGetters$pa;
  const {
    chrome,
    http,
    application
  } = (0, _kibana.useKibana)().services;
  const breadcrumbs = ((_breadcrumbGetters$pa = breadcrumbGetters[page]) === null || _breadcrumbGetters$pa === void 0 ? void 0 : _breadcrumbGetters$pa.call(breadcrumbGetters, values).map(breadcrumb => {
    const href = breadcrumb.href ? http.basePath.prepend(`${_constants.BASE_PATH}${breadcrumb.href}`) : undefined;
    return {
      ...breadcrumb,
      href,
      onClick: href ? ev => {
        if (ev.metaKey || ev.altKey || ev.ctrlKey || ev.shiftKey) {
          return;
        }
        ev.preventDefault();
        application.navigateToUrl(href);
      } : undefined
    };
  })) || [];
  const docTitle = [...breadcrumbs].reverse().map(breadcrumb => breadcrumb.text);
  chrome.docTitle.change(docTitle);
  chrome.setBreadcrumbs(breadcrumbs);
}