"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAllAgents = void 0;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _constants = require("../../common/constants");
var _use_error_toast = require("../common/hooks/use_error_toast");
var _kibana = require("../common/lib/kibana");
var _use_osquery_policies = require("./use_osquery_policies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO: break out the paginated vs all cases into separate hooks
const useAllAgents = (searchValue = '', opts = {
  perPage: 9000
}) => {
  const {
    perPage,
    agentIds
  } = opts;
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const setErrorToast = (0, _use_error_toast.useErrorToast)();
  const {
    data: osqueryPolicies,
    isFetched
  } = (0, _use_osquery_policies.useOsqueryPolicies)();
  return (0, _reactQuery.useQuery)({
    queryKey: ['agents', osqueryPolicies, searchValue, perPage, agentIds],
    queryFn: () => {
      let kuery = '';
      if (osqueryPolicies !== null && osqueryPolicies !== void 0 && osqueryPolicies.length) {
        kuery = `(${osqueryPolicies.map(p => `policy_id:${p}`).join(' or ')})`;
        if (searchValue) {
          kuery += ` and (local_metadata.host.hostname.keyword:*${searchValue}* or local_metadata.elastic.agent.id:*${searchValue}* or policy_id: *${searchValue}* or local_metadata.os.platform: *${searchValue}* or policy_name:${searchValue} )`;
        } else {
          kuery += ` and (status:online ${agentIds !== null && agentIds !== void 0 && agentIds.length ? `or local_metadata.elastic.agent.id:(${agentIds.join(' or ')})` : ''})`;
        }
      }
      return http.get(`/internal/osquery/fleet_wrapper/agents`, {
        version: _constants.API_VERSIONS.internal.v1,
        query: {
          kuery,
          perPage
        }
      });
    },
    enabled: isFetched && !!(osqueryPolicies !== null && osqueryPolicies !== void 0 && osqueryPolicies.length),
    onSuccess: () => setErrorToast(),
    onError: error => {
      var _error$body;
      return (
        // @ts-expect-error update types
        setErrorToast(error === null || error === void 0 ? void 0 : error.body, {
          title: _i18n.i18n.translate('xpack.osquery.agents.fetchError', {
            defaultMessage: 'Error while fetching agents'
          }),
          // @ts-expect-error update types
          toastMessage: error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.error
        })
      );
    }
  });
};
exports.useAllAgents = useAllAgents;