"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.replaceParamsQuery = exports.containsDynamicQuery = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CONTAINS_DYNAMIC_PARAMETER_REGEX = /\{{([^}]+)\}}/g; // when there are 2 opening and 2 closing curly brackets (including brackets)

const replaceParamsQuery = (query, data) => {
  if (!containsDynamicQuery(query)) {
    return {
      result: query,
      skipped: false
    };
  }
  const matchedBrackets = query.match(new RegExp(CONTAINS_DYNAMIC_PARAMETER_REGEX));
  let resultQuery = query;
  if (matchedBrackets) {
    (0, _lodash.each)(matchedBrackets, bracesText => {
      const field = bracesText.replace(/{{|}}/g, '').trim();
      if (resultQuery.includes(bracesText)) {
        const foundFieldValue = (0, _lodash.get)(data, field);
        if (foundFieldValue) {
          resultQuery = resultQuery.replace(bracesText, foundFieldValue);
        }
      }
    });
  }
  const skipped = new RegExp(CONTAINS_DYNAMIC_PARAMETER_REGEX).test(resultQuery);
  return {
    result: resultQuery,
    skipped
  };
};
exports.replaceParamsQuery = replaceParamsQuery;
const containsDynamicQuery = query => new RegExp(CONTAINS_DYNAMIC_PARAMETER_REGEX).test(query);
exports.containsDynamicQuery = containsDynamicQuery;