"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.versionOrUndefined = exports.version = exports.timeoutOrUndefined = exports.timeout = exports.stringArrayOrUndefined = exports.snapshotOrUndefined = exports.snapshot = exports.savedQueryIdOrUndefined = exports.savedQueryId = exports.removedOrUndefined = exports.removed = exports.queryOrUndefined = exports.query = exports.queriesOrUndefined = exports.queries = exports.platformOrUndefined = exports.platform = exports.packIdOrUndefined = exports.packId = exports.objectQueries = exports.intervalOrUndefined = exports.interval = exports.idOrUndefined = exports.id = exports.executionContextOrUndefined = exports.executionContext = exports.ecsMappingOrUndefined = exports.ecsMapping = exports.descriptionOrUndefined = exports.description = exports.arrayQueries = exports.agentSelectionOrUndefined = exports.agentSelection = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _ioTsUtils = require("@kbn/io-ts-utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const id = exports.id = t.string;
const idOrUndefined = exports.idOrUndefined = t.union([id, t.undefined]);
const agentSelection = exports.agentSelection = t.type({
  agents: t.array(t.string),
  allAgentsSelected: t.boolean,
  platformsSelected: t.array(t.string),
  policiesSelected: t.array(t.string)
});
const agentSelectionOrUndefined = exports.agentSelectionOrUndefined = t.union([agentSelection, t.undefined]);
const description = exports.description = t.string;
const descriptionOrUndefined = exports.descriptionOrUndefined = t.union([description, t.undefined]);
const platform = exports.platform = t.string;
const platformOrUndefined = exports.platformOrUndefined = t.union([platform, t.undefined]);
const query = exports.query = t.string;
const queryOrUndefined = exports.queryOrUndefined = t.union([query, t.undefined]);
const version = exports.version = t.string;
const versionOrUndefined = exports.versionOrUndefined = t.union([version, t.undefined]);
const interval = exports.interval = t.string;
const intervalOrUndefined = exports.intervalOrUndefined = t.union([interval, t.undefined]);
const timeout = exports.timeout = (0, _ioTsUtils.inRangeRt)(60, 60 * 15);
const timeoutOrUndefined = exports.timeoutOrUndefined = t.union([timeout, t.undefined]);
const snapshot = exports.snapshot = t.boolean;
const snapshotOrUndefined = exports.snapshotOrUndefined = t.union([snapshot, t.undefined]);
const removed = exports.removed = t.boolean;
const removedOrUndefined = exports.removedOrUndefined = t.union([removed, t.undefined]);
const savedQueryId = exports.savedQueryId = t.string;
const savedQueryIdOrUndefined = exports.savedQueryIdOrUndefined = t.union([savedQueryId, t.undefined]);
const packId = exports.packId = t.string;
const packIdOrUndefined = exports.packIdOrUndefined = t.union([packId, t.undefined]);
const executionContext = exports.executionContext = t.type({
  name: t.union([t.string, t.undefined]),
  url: t.union([t.string, t.undefined])
});
const executionContextOrUndefined = exports.executionContextOrUndefined = t.union([executionContext, t.undefined]);
const ecsMapping = exports.ecsMapping = t.record(t.string, t.partial({
  field: t.string,
  value: t.union([t.string, t.array(t.string)])
}));
const ecsMappingOrUndefined = exports.ecsMappingOrUndefined = t.union([ecsMapping, t.undefined]);
const stringArrayOrUndefined = exports.stringArrayOrUndefined = t.union([t.array(t.string), t.undefined]);
const arrayQueries = exports.arrayQueries = t.array(t.type({
  id,
  query,
  ecs_mapping: ecsMappingOrUndefined,
  version: versionOrUndefined,
  platform: platformOrUndefined,
  removed: removedOrUndefined,
  snapshot: snapshotOrUndefined
}));
const objectQueries = exports.objectQueries = t.record(t.string, t.type({
  query,
  id,
  ecs_mapping: ecsMappingOrUndefined,
  version: versionOrUndefined,
  platform: platformOrUndefined,
  saved_query_id: savedQueryIdOrUndefined,
  removed: removedOrUndefined,
  snapshot: snapshotOrUndefined
}));
const queries = exports.queries = t.union([arrayQueries, objectQueries]);
const queriesOrUndefined = exports.queriesOrUndefined = t.union([arrayQueries, t.undefined]); // in the future we might need to support `objectQueries` so use `queries` instead of `arrayQueries` - now removing this because of strange type issue where query is a number