"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFilterLabel = tag => {
  return _i18n.i18n.translate('xpack.observabilityShared.getFilterLabel.filter', {
    defaultMessage: 'Click to filter list with tag {tag}',
    values: {
      tag
    }
  });
};
const TagsList = ({
  ignoreEmpty,
  tags,
  numberOfTagsToDisplay = 3,
  onClick,
  color = 'hollow',
  disableExpand = false,
  prependChildren
}) => {
  const [toDisplay, setToDisplay] = (0, _react.useState)(numberOfTagsToDisplay);
  if (!tags || tags.length === 0) {
    if (ignoreEmpty) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.observabilityShared.tagsList.TextLabel', {
      defaultMessage: '--'
    }));
  }
  const tagsToDisplay = tags.slice(0, toDisplay);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    gutterSize: "xs",
    css: {
      maxWidth: 400
    },
    alignItems: "center"
  }, prependChildren, tagsToDisplay.map(tag =>
  /*#__PURE__*/
  // filtering only makes sense in monitor list, where we have summary
  _react.default.createElement(_eui.EuiFlexItem, {
    key: tag,
    grow: false
  }, onClick ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    key: tag,
    title: getFilterLabel(tag),
    onClick: () => {
      onClick(tag);
    },
    onMouseDown: e => {
      e.stopPropagation(); // stops propagation of metric onElementClick
    },
    onClickAriaLabel: getFilterLabel(tag),
    color: color,
    className: "eui-textTruncate",
    css: {
      maxWidth: 120
    }
  }, tag) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    key: tag,
    color: color,
    className: "eui-textTruncate",
    css: {
      maxWidth: 120
    }
  }, tag))), tags.length > toDisplay && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: tags.length - toDisplay,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, tags.slice(toDisplay, tags.length).map(tag => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      key: tag,
      size: "s"
    }, tag)))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: color,
    onClick: () => {
      if (disableExpand) {
        return;
      }
      setToDisplay(tags.length);
    },
    onMouseDown: e => {
      e.stopPropagation(); // stops propagation of metric onElementClick
    },
    onClickAriaLabel: EXPAND_TAGS_LABEL
  }, "+", tags.length - toDisplay))), toDisplay > 3 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: tags.length - 3,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: COLLAPSE_TAGS_LABEL,
    key: toDisplay
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: color,
    onClick: () => {
      setToDisplay(3);
    },
    onMouseDown: e => {
      e.stopPropagation(); // stops propagation of metric onElementClick
    },
    onClickAriaLabel: COLLAPSE_TAGS_LABEL
  }, "-", tags.length - 3))));
};

// eslint-disable-next-line import/no-default-export
var _default = exports.default = TagsList;
const EXPAND_TAGS_LABEL = _i18n.i18n.translate('xpack.observabilityShared.tagsList.expand', {
  defaultMessage: 'Click to view remaining tags'
});
const COLLAPSE_TAGS_LABEL = _i18n.i18n.translate('xpack.observabilityShared.tagsList.collapse', {
  defaultMessage: 'Click to collapse tags'
});
module.exports = exports.default;