"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NavNameWithBetaBadge = NavNameWithBetaBadge;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function NavNameWithBetaBadge({
  label,
  iconType,
  isTechnicalPreview
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "eui-textTruncate"
  }, /*#__PURE__*/_react.default.createElement("span", null, label))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      height: 20
    }
  }, isTechnicalPreview ? /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    color: "hollow",
    size: "s",
    label: _i18n.i18n.translate('xpack.observabilityShared.navigation.experimentalBadgeLabel', {
      defaultMessage: 'Technical preview'
    }),
    iconType: iconType
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    color: "hollow",
    size: "s",
    label: _i18n.i18n.translate('xpack.observabilityShared.navigation.betaBadge', {
      defaultMessage: 'Beta'
    })
  })));
}