"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSearchConfigurationBoolQuery = exports.getParsedFilterQuery = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getParsedFilterQuery = filter => {
  if (!filter) return [];
  try {
    const parsedQuery = (0, _esQuery.toElasticsearchQuery)((0, _esQuery.fromKueryExpression)(filter));
    return [parsedQuery];
  } catch (error) {
    throw _boom.default.badRequest(`Invalid filter query: ${error.message}`);
  }
};
exports.getParsedFilterQuery = getParsedFilterQuery;
const getSearchConfigurationBoolQuery = (searchConfiguration, additionalFilters, esQueryConfig) => {
  try {
    const searchConfigurationFilters = searchConfiguration.filter || [];
    const filters = [...additionalFilters, ...searchConfigurationFilters];
    return (0, _esQuery.buildEsQuery)(undefined, searchConfiguration.query, filters, esQueryConfig);
  } catch (error) {
    throw _boom.default.badRequest(`Invalid search query: ${error.message}`);
  }
};
exports.getSearchConfigurationBoolQuery = getSearchConfigurationBoolQuery;