"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildRecoveredAlertReason = exports.buildNoDataAlertReason = exports.buildFiredAlertReason = exports.buildErrorAlertReason = void 0;
var _i18n = require("@kbn/i18n");
var _alertingComparators = require("@kbn/alerting-comparators");
var _i18n2 = require("../../../../common/i18n");
var _common = require("../../../../common");
var _format_alert_result = require("./lib/format_alert_result");
var _translations = require("./translations");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toNumber = value => typeof value === 'string' ? parseFloat(value) : value;
const recoveredComparatorToI18n = (comparator, threshold, currentValue) => {
  switch (comparator) {
    case _alertingComparators.COMPARATORS.BETWEEN:
      return currentValue < threshold[0] ? _i18n2.BELOW_TEXT : _i18n2.ABOVE_TEXT;
    case _alertingComparators.COMPARATORS.NOT_BETWEEN:
      return _i18n2.BETWEEN_TEXT;
    case _alertingComparators.COMPARATORS.GREATER_THAN:
      return _i18n2.ABOVE_TEXT;
    case _alertingComparators.COMPARATORS.GREATER_THAN_OR_EQUALS:
      return _i18n2.ABOVE_OR_EQ_TEXT;
    case _alertingComparators.COMPARATORS.LESS_THAN:
      return _i18n2.BELOW_TEXT;
    case _alertingComparators.COMPARATORS.LESS_THAN_OR_EQUALS:
      return _i18n2.BELOW_OR_EQ_TEXT;
  }
};
const alertComparatorToI18n = comparator => {
  switch (comparator) {
    case _alertingComparators.COMPARATORS.BETWEEN:
      return _i18n2.BETWEEN_TEXT;
    case _alertingComparators.COMPARATORS.NOT_BETWEEN:
      return _i18n2.NOT_BETWEEN_TEXT;
    case _alertingComparators.COMPARATORS.GREATER_THAN:
      return _i18n2.ABOVE_TEXT;
    case _alertingComparators.COMPARATORS.GREATER_THAN_OR_EQUALS:
      return _i18n2.ABOVE_OR_EQ_TEXT;
    case _alertingComparators.COMPARATORS.LESS_THAN:
      return _i18n2.BELOW_TEXT;
    case _alertingComparators.COMPARATORS.LESS_THAN_OR_EQUALS:
      return _i18n2.BELOW_OR_EQ_TEXT;
  }
};
const thresholdToI18n = ([a, b]) => {
  if (typeof b === 'undefined') return a;
  return _i18n.i18n.translate('xpack.observability.customThreshold.rule.threshold.thresholdRange', {
    defaultMessage: '{a} and {b}',
    values: {
      a,
      b
    }
  });
};
const formatGroup = group => group === _constants.UNGROUPED_FACTORY_KEY ? '' : ` for ${group}`;
const buildFiredAlertReason = (alertResults, group, dataView) => {
  const aggregationReason = alertResults.map(result => buildAggregationReason((0, _format_alert_result.formatAlertResult)(result[group]))).join('; ') + '.';
  const sharedReason = '(' + [_i18n.i18n.translate('xpack.observability.customThreshold.rule.reason.forTheLast', {
    defaultMessage: 'duration: {duration}',
    values: {
      duration: (0, _common.formatDurationFromTimeUnitChar)(alertResults[0][group].timeSize, alertResults[0][group].timeUnit)
    }
  }), _i18n.i18n.translate('xpack.observability.customThreshold.rule.reason.dataView', {
    defaultMessage: 'data view: {dataView}',
    values: {
      dataView
    }
  }), group !== _constants.UNGROUPED_FACTORY_KEY ? _i18n.i18n.translate('xpack.observability.customThreshold.rule.reason.group', {
    defaultMessage: 'group: {group}',
    values: {
      group
    }
  }) : null].filter(item => !!item).join(', ') + ')';
  return aggregationReason + ' ' + sharedReason;
};
exports.buildFiredAlertReason = buildFiredAlertReason;
const buildAggregationReason = ({
  label,
  comparator,
  threshold,
  currentValue
}) => _i18n.i18n.translate('xpack.observability.customThreshold.rule.threshold.firedAlertReason', {
  defaultMessage: '{label} is {currentValue}, {comparator} the threshold of {threshold}',
  values: {
    label,
    comparator: alertComparatorToI18n((0, _common.convertToBuiltInComparators)(comparator)),
    threshold: thresholdToI18n(threshold),
    currentValue
  }
});

// Once recovered reason messages are re-enabled, checkout this issue https://github.com/elastic/kibana/issues/121272 regarding latest reason format
const buildRecoveredAlertReason = ({
  group,
  label = _translations.CUSTOM_EQUATION_I18N,
  comparator,
  threshold,
  currentValue
}) => _i18n.i18n.translate('xpack.observability.customThreshold.rule.threshold.recoveredAlertReason', {
  defaultMessage: '{label} is now {comparator} a threshold of {threshold} (current value is {currentValue}) for {group}',
  values: {
    label,
    comparator: recoveredComparatorToI18n(comparator, threshold.map(toNumber), toNumber(currentValue)),
    threshold: thresholdToI18n(threshold),
    currentValue,
    group
  }
});
exports.buildRecoveredAlertReason = buildRecoveredAlertReason;
const buildNoDataAlertReason = ({
  group,
  label = _translations.CUSTOM_EQUATION_I18N,
  timeSize,
  timeUnit
}) => _i18n.i18n.translate('xpack.observability.customThreshold.rule.threshold.noDataAlertReason', {
  defaultMessage: '{label} reported no data in the last {interval}{group}',
  values: {
    label,
    interval: `${timeSize}${timeUnit}`,
    group: formatGroup(group)
  }
});
exports.buildNoDataAlertReason = buildNoDataAlertReason;
const buildErrorAlertReason = metric => _i18n.i18n.translate('xpack.observability.customThreshold.rule.threshold.errorAlertReason', {
  defaultMessage: 'Elasticsearch failed when attempting to query data for {metric}',
  values: {
    metric
  }
});
exports.buildErrorAlertReason = buildErrorAlertReason;