"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFindProximalAlerts = void 0;
var _use_search_alerts_query = require("@kbn/alerts-ui-shared/src/common/hooks/use_search_alerts_query");
var _constants = require("../../../../common/constants");
var _kibana_react = require("../../../utils/kibana_react");
var _get_build_related_alerts_query = require("./related_alerts/get_build_related_alerts_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFindProximalAlerts = alertDetail => {
  const {
    services
  } = (0, _kibana_react.useKibana)();
  const esQuery = (0, _get_build_related_alerts_query.getBuildRelatedAlertsQuery)({
    alert: alertDetail.formatted,
    filterProximal: true
  });
  return (0, _use_search_alerts_query.useSearchAlertsQuery)({
    data: services.data,
    ruleTypeIds: _constants.OBSERVABILITY_RULE_TYPE_IDS_WITH_SUPPORTED_STACK_RULE_TYPES,
    consumers: _constants.observabilityAlertFeatureIds,
    query: esQuery,
    skipAlertsQueryContext: true
  });
};
exports.useFindProximalAlerts = useFindProximalAlerts;