"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBuildRelatedAlertsQuery = getBuildRelatedAlertsQuery;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _dedent = _interopRequireDefault(require("dedent"));
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getBuildRelatedAlertsQuery({
  alert,
  filterProximal
}) {
  var _alert$fields$ALERT_R, _alert$fields$ALERT_I, _alert$fields$ALERT_I2;
  const groups = alert.fields[_ruleDataUtils.ALERT_GROUP];
  const shouldGroups = [];
  groups === null || groups === void 0 ? void 0 : groups.forEach(({
    field,
    value
  }) => {
    if (!field || !value) return;
    shouldGroups.push({
      bool: {
        boost: 2.0,
        must: [{
          term: {
            'kibana.alert.group.field': field
          }
        }, {
          term: {
            'kibana.alert.group.value': value
          }
        }]
      }
    });
  });
  const shouldRule = alert.fields[_ruleDataUtils.ALERT_RULE_UUID] ? [{
    term: {
      'kibana.alert.rule.uuid': {
        value: alert.fields[_ruleDataUtils.ALERT_RULE_UUID],
        boost: 1.0
      }
    }
  }] : [];
  const startDate = (0, _moment.default)(alert.fields[_ruleDataUtils.ALERT_START]);
  const endDate = alert.fields[_ruleDataUtils.ALERT_END] ? (0, _moment.default)(alert.fields[_ruleDataUtils.ALERT_END]) : undefined;
  const tags = (_alert$fields$ALERT_R = alert.fields[_ruleDataUtils.ALERT_RULE_TAGS]) !== null && _alert$fields$ALERT_R !== void 0 ? _alert$fields$ALERT_R : [];
  const instanceId = (_alert$fields$ALERT_I = (_alert$fields$ALERT_I2 = alert.fields[_ruleDataUtils.ALERT_INSTANCE_ID]) === null || _alert$fields$ALERT_I2 === void 0 ? void 0 : _alert$fields$ALERT_I2.split(',')) !== null && _alert$fields$ALERT_I !== void 0 ? _alert$fields$ALERT_I : [];
  const range = filterProximal ? [30, 'minutes'] : [1, 'days'];
  return {
    bool: {
      filter: [{
        range: {
          [_ruleDataUtils.ALERT_START]: {
            gte: startDate.clone().subtract(...range).toISOString(),
            lte: startDate.clone().add(...range).toISOString()
          }
        }
      }],
      must_not: [{
        term: {
          [_ruleDataUtils.ALERT_UUID]: {
            value: alert.fields[_ruleDataUtils.ALERT_UUID]
          }
        }
      }],
      should: [...shouldGroups, ...shouldRule, {
        term: {
          [_ruleDataUtils.ALERT_STATUS]: {
            value: alert.fields[_ruleDataUtils.ALERT_STATUS],
            boost: 2
          }
        }
      }, {
        function_score: {
          functions: [{
            exp: {
              [_ruleDataUtils.ALERT_START]: {
                origin: startDate.toISOString(),
                scale: '10m',
                offset: '10m',
                decay: 0.5
              }
            },
            weight: 10
          }, ...(endDate ? [{
            exp: {
              [_ruleDataUtils.ALERT_END]: {
                origin: endDate.toISOString(),
                scale: '10m',
                offset: '10m',
                decay: 0.5
              }
            },
            weight: 10
          }] : []), {
            script_score: {
              script: {
                source: (0, _dedent.default)(`
                      double jaccardSimilarity(Set a, Set b) {
                        if (a.size() == 0 || b.size() == 0) return 0.0;
                        Set intersection = new HashSet(a);
                        intersection.retainAll(b);
                        Set union = new HashSet(a);
                        union.addAll(b);
                        return (double) intersection.size() / union.size();
                      }
                      Set tagsQuery = new HashSet(params.tags);
                      Set tagsDoc = new HashSet(doc.containsKey("kibana.alert.rule.tags") && !doc.get("kibana.alert.rule.tags").empty ? doc.get("kibana.alert.rule.tags") : []);
                      return 1.0 + jaccardSimilarity(tagsQuery, tagsDoc);
                    `),
                params: {
                  tags
                }
              }
            },
            weight: 2
          }, {
            script_score: {
              script: {
                source: (0, _dedent.default)(`
                      double jaccardSimilarity(Set a, Set b) {
                        if (a.size() == 0 || b.size() == 0) return 0.0;
                        Set intersection = new HashSet(a);
                        intersection.retainAll(b);
                        Set union = new HashSet(a);
                        union.addAll(b);
                        return (double) intersection.size() / union.size();
                      }
                      Set instanceIdQuery = new HashSet(params.instanceId);
                      Set instanceIdDoc = new HashSet();
                      if (doc.containsKey('kibana.alert.instance.id')) {
                        String instanceIdStr = doc['kibana.alert.instance.id'].value;
                        if (instanceIdStr != null && !instanceIdStr.isEmpty()) {
                          StringTokenizer tokenizer = new StringTokenizer(instanceIdStr, ',');
                          while (tokenizer.hasMoreTokens()) {
                            instanceIdDoc.add(tokenizer.nextToken());
                          }
                        }
                      }

                      return 1.0 + jaccardSimilarity(instanceIdQuery, instanceIdDoc);
                    `),
                params: {
                  instanceId
                }
              }
            },
            weight: 5
          }],
          score_mode: 'multiply',
          boost_mode: 'sum'
        }
      }]
    }
  };
}