"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchAlertDetail = void 0;
var _react = require("react");
var _lodash = require("lodash");
var _constants = require("@kbn/rule-registry-plugin/common/constants");
var _use_plugin_context = require("./use_plugin_context");
var _use_data_fetcher = require("./use_data_fetcher");
var _parse_alert = require("../pages/alerts/helpers/parse_alert");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchAlertDetail = id => {
  const {
    observabilityRuleTypeRegistry
  } = (0, _use_plugin_context.usePluginContext)();
  const params = (0, _react.useMemo)(() => ({
    id,
    ruleType: observabilityRuleTypeRegistry
  }), [id, observabilityRuleTypeRegistry]);
  const shouldExecuteApiCall = (0, _react.useCallback)(apiCallParams => !(0, _lodash.isEmpty)(apiCallParams.id), []);
  const {
    loading,
    data: rawAlert
  } = (0, _use_data_fetcher.useDataFetcher)({
    paramsForApiCall: params,
    initialDataState: null,
    executeApiCall: fetchAlert,
    shouldExecuteApiCall
  });
  const data = (0, _react.useMemo)(() => {
    return rawAlert ? {
      formatted: (0, _parse_alert.parseAlert)(observabilityRuleTypeRegistry)(rawAlert),
      raw: rawAlert
    } : null;
  }, [observabilityRuleTypeRegistry, rawAlert]);
  return [loading, data];
};
exports.useFetchAlertDetail = useFetchAlertDetail;
const fetchAlert = async ({
  id
}, abortController, http) => {
  return http.get(_constants.BASE_RAC_ALERTS_API_PATH, {
    query: {
      id
    },
    signal: abortController.signal
  }).catch(() => {
    // ignore error for retrieving alert
    return null;
  });
};