"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFormatterForMetric = void 0;
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _formatters = require("../../../../common/custom_threshold_rule/formatters");
var _metric_to_format = require("./metric_to_format");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createFormatterForMetric = metrics => {
  if (metrics.length === 1) {
    const format = (0, _metric_to_format.metricToFormat)(metrics[0]);
    return (0, _formatters.createFormatter)(format);
  }
  return input => (0, _numeral.default)(input).format('0.[0000]');
};
exports.createFormatterForMetric = createFormatterForMetric;