"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateDomain = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMin = values => {
  const minValue = (0, _lodash.min)(values);
  return (0, _lodash.isNumber)(minValue) && Number.isFinite(minValue) ? minValue : undefined;
};
const getMax = values => {
  const maxValue = (0, _lodash.max)(values);
  return (0, _lodash.isNumber)(maxValue) && Number.isFinite(maxValue) ? maxValue : undefined;
};
const calculateDomain = series => {
  const values = series.rows.map(row => row.metric_0).filter(v => (0, _lodash.isNumber)(v));
  return {
    min: getMin(values) || 0,
    max: getMax(values) || 0
  };
};
exports.calculateDomain = calculateDomain;