"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.overviewColumns = exports.ColumnIDs = void 0;
var _eui = require("@elastic/eui");
var _alert_lifecycle_status_badge = require("@kbn/alerts-ui-shared/src/alert_lifecycle_status_badge");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireDefault(require("react"));
var _casesComponents = require("@kbn/cases-components");
var _alertingComparators = require("@kbn/alerting-comparators");
var _convert_legacy_outside_comparator = require("../../../common/utils/convert_legacy_outside_comparator");
var _format_cases = require("./helpers/format_cases");
var _groups = require("../alert_sources/groups");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ColumnIDs = exports.ColumnIDs = {
  STATUS: 'status',
  SOURCE: 'source',
  TRIGGERED: 'triggered',
  DURATION: 'duration',
  OBSERVED_VALUE: 'observed_value',
  THRESHOLD: 'threshold',
  RULE_NAME: 'rule_name',
  RULE_TYPE: 'rule_type',
  CASES: 'cases'
};
const overviewColumns = exports.overviewColumns = [{
  field: 'key',
  name: '',
  width: '30%'
}, {
  field: 'value',
  name: '',
  render: (value, {
    id,
    meta
  }) => {
    if (!value && value !== 0 && !meta) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, '-');
    const ruleCriteria = meta === null || meta === void 0 ? void 0 : meta.ruleCriteria;
    switch (id) {
      case ColumnIDs.STATUS:
        const alertStatus = value;
        const flapping = meta === null || meta === void 0 ? void 0 : meta.flapping;
        return /*#__PURE__*/_react.default.createElement(_alert_lifecycle_status_badge.AlertLifecycleStatusBadge, {
          alertStatus: alertStatus,
          flapping: flapping
        });
      case ColumnIDs.SOURCE:
        const groups = meta === null || meta === void 0 ? void 0 : meta.groups;
        if (!groups.length) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, '-');
        const alertEnd = meta === null || meta === void 0 ? void 0 : meta.alertEnd;
        const timeRange = meta === null || meta === void 0 ? void 0 : meta.timeRange;
        return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_groups.Groups, {
          groups: groups,
          timeRange: alertEnd ? timeRange : {
            ...timeRange,
            to: 'now'
          }
        }));
      case ColumnIDs.TRIGGERED:
        const triggeredDate = value;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s"
        }, (0, _moment.default)(triggeredDate).format(meta === null || meta === void 0 ? void 0 : meta.dateFormat));
      case ColumnIDs.DURATION:
        const duration = value;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s"
        }, /*#__PURE__*/_react.default.createElement("h4", null, _moment.default.duration(duration / 1000).humanize()));
      case ColumnIDs.RULE_NAME:
        const ruleName = value;
        const ruleLink = meta === null || meta === void 0 ? void 0 : meta.ruleLink;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "alertFlyoutOverview",
          href: ruleLink ? ruleLink : '#'
        }, ruleName);
      case ColumnIDs.OBSERVED_VALUE:
        if (!ruleCriteria) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, '-');
        return /*#__PURE__*/_react.default.createElement("div", null, ruleCriteria.map((criteria, criteriaIndex) => {
          const observedValue = criteria.observedValue;
          const pctAboveThreshold = criteria.pctAboveThreshold;
          return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "s",
            key: `${observedValue}-${criteriaIndex}`
          }, /*#__PURE__*/_react.default.createElement("h4", {
            style: {
              display: 'inline'
            }
          }, observedValue), /*#__PURE__*/_react.default.createElement("span", null, pctAboveThreshold));
        }), ruleCriteria.length > 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
          size: "s",
          title: _i18n.i18n.translate('xpack.observability.columns.euiCallOut.multipleConditionsLabel', {
            defaultMessage: 'Multiple conditions'
          }),
          iconType: "alert"
        }));
      case ColumnIDs.THRESHOLD:
        if (!ruleCriteria) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, '-');
        return /*#__PURE__*/_react.default.createElement("div", null, ruleCriteria.map((criteria, criticalIndex) => {
          const {
            threshold,
            comparator
          } = criteria;
          let formattedComparator = comparator.toUpperCase();
          if (comparator === _alertingComparators.COMPARATORS.NOT_BETWEEN || comparator === _convert_legacy_outside_comparator.LEGACY_COMPARATORS.OUTSIDE_RANGE) {
            // No need for i18n as we are using the enum value, we only need a space.
            formattedComparator = 'NOT BETWEEN';
          }
          return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "s",
            key: `${threshold}-${criticalIndex}`
          }, /*#__PURE__*/_react.default.createElement("h4", null, `${formattedComparator} ${threshold}`));
        }));
      case ColumnIDs.RULE_TYPE:
        const ruleType = value;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s"
        }, ruleType);
      case ColumnIDs.CASES:
        const cases = meta === null || meta === void 0 ? void 0 : meta.cases;
        const isLoading = meta === null || meta === void 0 ? void 0 : meta.isLoading;
        if (isLoading) return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
          size: "m"
        });
        if (!cases || !cases.length) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, '-');
        const navigateToCaseView = meta === null || meta === void 0 ? void 0 : meta.navigateToCaseView;
        return cases.map((caseInfo, index) => {
          return [index > 0 && index < cases.length && ', ', /*#__PURE__*/_react.default.createElement(_casesComponents.Tooltip, {
            loading: false,
            content: (0, _format_cases.formatCase)(caseInfo),
            key: caseInfo.id
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            key: caseInfo.id,
            onClick: () => navigateToCaseView({
              caseId: caseInfo.id
            }),
            "data-test-subj": "o11yAlertFlyoutOverviewTabCasesLink"
          }, caseInfo.title))];
        });
      default:
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, '-');
    }
  }
}];