"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getObservabilityOnboardingFlow = getObservabilityOnboardingFlow;
var _observability_onboarding_status = require("../../saved_objects/observability_onboarding_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getObservabilityOnboardingFlow({
  savedObjectsClient,
  savedObjectId
}) {
  try {
    const result = await savedObjectsClient.get(_observability_onboarding_status.OBSERVABILITY_ONBOARDING_STATE_SAVED_OBJECT_TYPE, savedObjectId);
    const {
      id,
      updated_at: updatedAt,
      attributes
    } = result;
    return {
      id,
      updatedAt: updatedAt ? Date.parse(updatedAt) : 0,
      ...attributes
    };
  } catch (error) {
    return undefined;
  }
}