"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateNavEvents = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createEvent = ({
  type,
  step,
  timestamp
}) => ({
  type,
  step,
  timestamp: timestamp !== null && timestamp !== void 0 ? timestamp : Date.now(),
  duration: 0
});
const generateNavEvents = ({
  type,
  step,
  navEvents
}) => {
  if (navEvents.length === 0) {
    return [createEvent({
      type: 'inital',
      step
    })];
  }
  const mutableNavEvents = [...navEvents];
  const previousEvent = mutableNavEvents[navEvents.length - 1];
  const timestamp = Date.now();
  previousEvent.duration = timestamp - previousEvent.timestamp;
  return [...mutableNavEvents, createEvent({
    type,
    step,
    timestamp
  })];
};
exports.generateNavEvents = generateNavEvents;