"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWindowBlurDataMonitoringTrigger = useWindowBlurDataMonitoringTrigger;
var _public = require("@kbn/kibana-react-plugin/public");
var _react = require("react");
var _useEvent = _interopRequireDefault(require("react-use/lib/useEvent"));
var _telemetry_events = require("../../../../common/telemetry_events");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useWindowBlurDataMonitoringTrigger({
  isActive,
  onboardingFlowType,
  onboardingId,
  telemetryEventContext
}) {
  const [windowLostFocus, setWindowLostFocus] = (0, _react.useState)(false);
  const {
    services: {
      analytics
    }
  } = (0, _public.useKibana)();
  (0, _useEvent.default)('blur', () => setWindowLostFocus(true), window);
  const isMonitoringData = isActive && windowLostFocus;
  (0, _react.useEffect)(() => {
    if (isMonitoringData) {
      analytics === null || analytics === void 0 ? void 0 : analytics.reportEvent(_telemetry_events.OBSERVABILITY_ONBOARDING_FLOW_PROGRESS_TELEMETRY_EVENT.eventType, {
        onboardingFlowType,
        onboardingId,
        step: 'awaiting_data',
        context: telemetryEventContext
      });
    }
  }, [analytics, isMonitoringData, onboardingFlowType, onboardingId, telemetryEventContext]);
  return isMonitoringData;
}