"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstallElasticAgentSteps = InstallElasticAgentSteps;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _buffer = require("buffer");
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _step_status = require("./step_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function InstallElasticAgentSteps({
  installAgentPlatformOptions,
  onSelectPlatform,
  selectedPlatform,
  installAgentCommand,
  autoDownloadConfig,
  onToggleAutoDownloadConfig,
  installAgentStatus,
  showInstallProgressSteps,
  installProgressSteps,
  configureAgentStatus,
  configureAgentYaml,
  appendedSteps = []
}) {
  var _installAgentPlatform, _installAgentPlatform2;
  const configPath = selectedPlatform === 'macos' ? '/Library/Elastic/Agent/elastic-agent.yml' : '/opt/Elastic/Agent/elastic-agent.yml';
  const isInstallStarted = (0, _lodash.intersection)(Object.keys(installProgressSteps), Object.keys(PROGRESS_STEP_TITLES(configPath))).length > 0;
  const autoDownloadConfigStep = getStep('ea-config', installProgressSteps, configPath);
  const customInstallStep = (_installAgentPlatform = installAgentPlatformOptions.find(step => step.id === selectedPlatform)) === null || _installAgentPlatform === void 0 ? void 0 : _installAgentPlatform.children;
  const disableSteps = (_installAgentPlatform2 = installAgentPlatformOptions.find(step => step.id === selectedPlatform)) === null || _installAgentPlatform2 === void 0 ? void 0 : _installAgentPlatform2.disableSteps;
  const installStepDefault = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "bash",
    isCopyable: true
  }, installAgentCommand), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), showInstallProgressSteps && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, ['ea-download', 'ea-extract', 'ea-install', 'ea-status'].map(stepId => {
    const {
      title,
      status,
      message
    } = getStep(stepId, installProgressSteps, configPath);
    return /*#__PURE__*/_react.default.createElement(_step_status.StepStatus, {
      status: status,
      title: title,
      message: message
    });
  }))));
  const configureStep = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, autoDownloadConfig ? _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.configStep.auto.description', {
    defaultMessage: 'The agent config below will be downloaded by the install script and written to ({configPath}). This will overwrite any existing agent configuration.',
    values: {
      configPath
    }
  }) : _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.configStep.manual.description', {
    defaultMessage: 'Add the following configuration to {configPath} on the host where you installed the Elastic Agent.',
    values: {
      configPath
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
    isLoading: false,
    contentAriaLabel: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.configStep.yamlCodeBlockdescription', {
      defaultMessage: 'Elastic Agent yaml configuration'
    }),
    width: "100%",
    height: 300,
    borderRadius: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "yaml",
    isCopyable: true,
    style: {
      opacity: autoDownloadConfig ? '.5' : '1'
    }
  }, configureAgentYaml)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "download",
    color: "primary",
    href: `data:application/yaml;base64,${_buffer.Buffer.from(configureAgentYaml, 'utf8').toString('base64')}`,
    download: "elastic-agent.yml",
    target: "_blank",
    isDisabled: autoDownloadConfig,
    "data-test-subj": "obltOnboardingConfigureElasticAgentStepDownloadConfig"
  }, _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.configStep.downloadConfigButton', {
    defaultMessage: 'Download config file'
  })), showInstallProgressSteps && autoDownloadConfig ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_step_status.StepStatus, {
    status: autoDownloadConfigStep.status,
    title: autoDownloadConfigStep.title,
    message: autoDownloadConfigStep.message
  }))) : null);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: [{
      'data-test-subj': 'obltOnboardingInstallElasticAgentStep',
      title: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.installStep.title', {
        defaultMessage: 'Install the Elastic Agent'
      }),
      status: installAgentStatus,
      children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.observability_onboarding.installElasticAgent.installStep.description",
        defaultMessage: "Select your platform, and run the install command in your terminal to enroll and start the Elastic Agent. Do this for each host. Review {hostRequirementsLink} before installing.",
        values: {
          hostRequirementsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "observabilityOnboardingInstallElasticAgentStepsHostRequirementsAndOtherInstallationOptionsLink",
            external: true,
            href: "https://www.elastic.co/guide/en/fleet/8.7/elastic-agent-installation.html"
          }, _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.installStep.hostRequirements', {
            defaultMessage: 'host requirements and other installation options'
          }))
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "l"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          alignItems: "center",
          gutterSize: "xs",
          responsive: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.installStep.autoDownloadConfig', {
          defaultMessage: "Automatically download the agent's config"
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          content: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.installStep.autoDownloadConfig.tooltip', {
            defaultMessage: "Turn on to add a string to the following code block that downloads the agent's standard configuration to your host during installation. Turn off to manually configure the agent in the next step."
          }),
          position: "right"
        }))),
        checked: autoDownloadConfig,
        onChange: onToggleAutoDownloadConfig,
        disabled: disableSteps || isInstallStarted,
        "data-test-subj": "obltOnboardingInstallElasticAgentAutoDownloadConfig"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "l"
      }), autoDownloadConfig && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.installStep.autoDownloadConfig.overwriteWarning', {
          defaultMessage: 'Automatically downloading the agent config will overwrite any existing agent config on your host.'
        }),
        color: "warning",
        iconType: "warning",
        "data-test-subj": "obltOnboardingInstallElasticAgentAutoDownloadConfigCallout"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "l"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
        isFullWidth: true,
        legend: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.installStep.choosePlatform', {
          defaultMessage: 'Choose platform'
        }),
        options: installAgentPlatformOptions.map(({
          id,
          label,
          isDisabled
        }) => ({
          id,
          label,
          isDisabled
        })),
        type: "single",
        idSelected: selectedPlatform,
        onChange: id => {
          onSelectPlatform(id);
        },
        isDisabled: isInstallStarted
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }), customInstallStep || installStepDefault)
    }, {
      'data-test-subj': 'obltOnboardingConfigureElasticAgentStep',
      title: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.configureStep.title', {
        defaultMessage: 'Configure the Elastic Agent'
      }),
      status: disableSteps ? 'disabled' : configureAgentStatus,
      children: disableSteps ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null) : configureStep
    }, ...appendedSteps.map(euiStep => ({
      children: null,
      ...euiStep,
      status: disableSteps ? 'disabled' : euiStep.status,
      'data-test-subj': euiStep['data-test-subj']
    }))]
  });
}
function getStep(id, installProgressSteps, configPath) {
  const {
    loadingTitle,
    completedTitle,
    incompleteTitle
  } = PROGRESS_STEP_TITLES(configPath)[id];
  const stepProgress = installProgressSteps[id];
  if (stepProgress) {
    const {
      status,
      message
    } = stepProgress;
    const title = status === 'loading' ? loadingTitle : status === 'complete' ? completedTitle : incompleteTitle;
    return {
      title,
      status: status !== null && status !== void 0 ? status : 'incomplete',
      message
    };
  }
  return {
    title: incompleteTitle,
    status: 'incomplete'
  };
}
const PROGRESS_STEP_TITLES = configPath => ({
  'ea-download': {
    incompleteTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaDownload.incompleteTitle', {
      defaultMessage: 'Download Elastic Agent'
    }),
    loadingTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaDownload.loadingTitle', {
      defaultMessage: 'Downloading Elastic Agent'
    }),
    completedTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaDownload.completedTitle', {
      defaultMessage: 'Elastic Agent downloaded'
    })
  },
  'ea-extract': {
    incompleteTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaExtract.incompleteTitle', {
      defaultMessage: 'Extract Elastic Agent'
    }),
    loadingTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaExtract.loadingTitle', {
      defaultMessage: 'Extracting Elastic Agent'
    }),
    completedTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaExtract.completedTitle', {
      defaultMessage: 'Elastic Agent extracted'
    })
  },
  'ea-install': {
    incompleteTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaInstall.incompleteTitle', {
      defaultMessage: 'Install Elastic Agent'
    }),
    loadingTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaInstall.loadingTitle', {
      defaultMessage: 'Installing Elastic Agent'
    }),
    completedTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaInstall.completedTitle', {
      defaultMessage: 'Elastic Agent installed'
    })
  },
  'ea-status': {
    incompleteTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaStatus.incompleteTitle', {
      defaultMessage: 'Connect to the Elastic Agent'
    }),
    loadingTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaStatus.loadingTitle', {
      defaultMessage: 'Connecting to the Elastic Agent'
    }),
    completedTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaStatus.completedTitle', {
      defaultMessage: 'Connected to the Elastic Agent'
    })
  },
  'ea-config': {
    incompleteTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaConfig.incompleteTitle', {
      defaultMessage: 'Configure the agent'
    }),
    loadingTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaConfig.loadingTitle', {
      defaultMessage: 'Downloading Elastic Agent config'
    }),
    completedTitle: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.eaConfig.completedTitle', {
      defaultMessage: 'Elastic Agent config written to {configPath}',
      values: {
        configPath
      }
    })
  }
});