"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CopyToClipboardButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CopyToClipboardButton = ({
  textToCopy,
  children,
  ...rest
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: textToCopy
  }, copyToClipboard => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    "data-test-subj": "observabilityOnboardingCopyToClipboardButton",
    iconType: "copyClipboard",
    onClick: copyToClipboard
  }, rest), children !== null && children !== void 0 ? children : _i18n.i18n.translate('xpack.observability_onboarding.copyToClipboardButton.copyToClipboardButtonLabel', {
    defaultMessage: 'Copy to clipboard'
  })));
};
exports.CopyToClipboardButton = CopyToClipboardButton;