"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OtelLogsPage = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _template = require("./template");
var _header = require("../header");
var _otel_logs = require("../quickstart_flows/otel_logs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OtelLogsPage = () => /*#__PURE__*/_react.default.createElement(_template.PageTemplate, {
  customHeader: /*#__PURE__*/_react.default.createElement(_header.CustomHeader, {
    logo: "opentelemetry",
    headlineCopy: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.customHeader.otel.text', {
      defaultMessage: 'OpenTelemetry'
    }),
    captionCopy: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.customHeader.otel.description', {
      defaultMessage: 'Collect logs and host metrics using the Elastic distribution of the OTel collector.'
    })
  })
}, /*#__PURE__*/_react.default.createElement(_otel_logs.OtelLogsPanel, null));
exports.OtelLogsPage = OtelLogsPage;