"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackageListSearchForm = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _useAsyncRetry = _interopRequireDefault(require("react-use/lib/useAsyncRetry"));
var _use_card_url_rewrite = require("./use_card_url_rewrite");
var _package_list = require("../package_list/package_list");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const fetchAvailablePackagesHook = () => Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/fleet-plugin/public'))).then(module => module.AvailablePackagesHook()).then(hook => hook.useAvailablePackages);
const Loading = () => /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
  isLoading: true,
  lines: 5
});
const PackageListGridWrapper = ({
  useAvailablePackages,
  packageListRef,
  searchQuery,
  setSearchQuery,
  customCards,
  flowCategory,
  excludePackageIdList = []
}) => {
  const {
    filteredCards: integrationCards,
    isLoading
  } = useAvailablePackages({
    prereleaseIntegrationsEnabled: false
  });
  const rewriteUrl = (0, _use_card_url_rewrite.useCardUrlRewrite)({
    category: flowCategory,
    search: searchQuery
  });
  const list = (0, _react.useMemo)(() => {
    return (customCards !== null && customCards !== void 0 ? customCards : []).concat(integrationCards).filter(card => card.categories.some(category => ['observability', 'os_system'].includes(category))).filter(card => !excludePackageIdList.includes(card.id)).map(rewriteUrl);
  }, [customCards, excludePackageIdList, integrationCards, rewriteUrl]);
  if (isLoading) return /*#__PURE__*/_react.default.createElement(Loading, null);
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: packageListRef
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    box: {
      incremental: true
    },
    onChange: ({
      queryText,
      error
    }) => {
      if (error) return;
      setSearchQuery(queryText);
    },
    query: searchQuery
  }), searchQuery !== '' && /*#__PURE__*/_react.default.createElement(_package_list.PackageList, {
    list: list,
    searchTerm: searchQuery,
    showCardLabels: false
  }));
};
const PackageListSearchForm = exports.PackageListSearchForm = /*#__PURE__*/_react.default.forwardRef((props, packageListRef) => {
  const ref = (0, _react.useRef)(null);
  const {
    error: errorLoading,
    retry: retryAsyncLoad,
    loading: asyncLoading
  } = (0, _useAsyncRetry.default)(async () => {
    ref.current = await fetchAvailablePackagesHook();
  });
  if (errorLoading) return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.observability_onboarding.asyncLoadFailureCallout.title', {
      defaultMessage: 'Loading failure'
    }),
    color: "warning",
    iconType: "cross",
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability_onboarding.asyncLoadFailureCallout.copy",
    defaultMessage: "Some required elements failed to load."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "warning",
    "data-test-subj": "xpack.observability_onboarding.asyncLoadFailureCallout.button",
    onClick: () => {
      if (!asyncLoading) retryAsyncLoad();
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability_onboarding.asyncLoadFailureCallout.buttonContent",
    defaultMessage: "Retry"
  })));
  if (asyncLoading || ref.current === null) return /*#__PURE__*/_react.default.createElement(Loading, null);
  return /*#__PURE__*/_react.default.createElement(PackageListGridWrapper, (0, _extends2.default)({}, props, {
    useAvailablePackages: ref.current,
    packageListRef: packageListRef
  }));
});