"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.configSchema = exports.config = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const configSchema = exports.configSchema = _configSchema.schema.object({
  enabled: _configSchema.schema.boolean({
    defaultValue: true
  }),
  navigation: _configSchema.schema.object({
    showAppLink: (0, _configSchema.offeringBasedSchema)({
      serverless: _configSchema.schema.boolean({
        defaultValue: true
      }),
      options: {
        defaultValue: false
      }
    })
  })
});
const config = exports.config = {
  schema: configSchema,
  deprecations: ({
    renameFromRoot,
    unused
  }) => [renameFromRoot('xpack.discoverLogExplorer.featureFlags.deepLinkVisible', 'xpack.observabilityLogsExplorer.navigation.showAppLink', {
    level: 'warning'
  }), renameFromRoot('xpack.observabilityLogExplorer.navigation.showAppLink', 'xpack.observabilityLogsExplorer.navigation.showAppLink', {
    level: 'warning'
  }), renameFromRoot('xpack.observabilityLogExplorer.enabled', 'xpack.observabilityLogsExplorer.enabled', {
    level: 'warning'
  }), unused('navigation.showAppLink', {
    level: 'warning'
  })],
  exposeToBrowser: {
    navigation: {
      showAppLink: true
    }
  }
};