"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.debug = debug;
var _util = require("util");
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function debug(prefix) {
  return source$ => {
    return source$.pipe((0, _rxjs.materialize)(), (0, _rxjs.tap)(event => {
      // eslint-disable-next-line no-console
      console.log(prefix + ':\n' + (0, _util.inspect)(event, {
        depth: 10
      }));
    }), (0, _rxjs.dematerialize)());
  };
}