"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TourCallout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TourCallout = ({
  title,
  content,
  step,
  stepsTotal,
  anchorPosition,
  children,
  isOpen = true,
  hasArrow = true,
  subtitle,
  maxWidth = 350,
  footerButtonLabel,
  zIndex,
  dismissTour,
  ...rest
}) => {
  const [isStepOpen, setIsStepOpen] = (0, _react.useState)(false);
  const handleFinish = () => {
    setIsStepOpen(false);
    if (dismissTour) {
      dismissTour();
    }
  };
  (0, _react.useEffect)(() => {
    let timeoutId;
    if (isOpen) {
      timeoutId = setTimeout(() => {
        setIsStepOpen(true);
      }, 250);
    } else {
      setIsStepOpen(false);
    }
    return () => {
      if (timeoutId) {
        clearTimeout(timeoutId);
      }
    };
  }, [isOpen]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, (0, _extends2.default)({
    title: title,
    subtitle: subtitle,
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m",
      css: (0, _react2.css)`
            line-height: 1.5;
          `
    }, content),
    step: step,
    stepsTotal: stepsTotal,
    anchorPosition: anchorPosition,
    repositionOnScroll: true,
    isStepOpen: isStepOpen,
    onFinish: handleFinish,
    hasArrow: hasArrow,
    maxWidth: maxWidth,
    zIndex: zIndex,
    footerAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      color: "text",
      onClick: handleFinish
    }, footerButtonLabel)
  }, rest), children);
};
exports.TourCallout = TourCallout;