"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.untilAborted = untilAborted;
var _rxjs = require("rxjs");
var _common = require("@kbn/kibana-utils-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function untilAborted(signal) {
  return source$ => {
    const signal$ = new _rxjs.Observable(subscriber => {
      if (signal.aborted) {
        subscriber.error(new _common.AbortError());
      }
      signal.addEventListener('abort', () => {
        subscriber.error(new _common.AbortError());
      });
    });
    return source$.pipe((0, _rxjs.takeUntil)(signal$));
  };
}