"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProductDocEntry = ProductDocEntry;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-ai-assistant-plugin/public");
var _use_kibana = require("../../../hooks/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const statusToButtonTextMap = {
  installing: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.installingText', {
    defaultMessage: 'Installing...'
  }),
  uninstalling: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.uninstallingText', {
    defaultMessage: 'Uninstalling...'
  }),
  installed: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.uninstallProductDocButtonLabel', {
    defaultMessage: 'Uninstall'
  }),
  uninstalled: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.installProductDocButtonLabel', {
    defaultMessage: 'Install'
  }),
  loading: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.loadingText', {
    defaultMessage: 'Loading...'
  })
};
function ProductDocEntry({
  knowledgeBase,
  productDoc,
  currentlyDeployedInferenceId
}) {
  var _knowledgeBase$status, _knowledgeBase$status2;
  const {
    overlays
  } = (0, _use_kibana.useKibana)().services;
  const canInstallProductDoc = currentlyDeployedInferenceId !== undefined && !(knowledgeBase.isInstalling || knowledgeBase.isWarmingUpModel || knowledgeBase.isPolling) && ((_knowledgeBase$status = knowledgeBase.status) === null || _knowledgeBase$status === void 0 ? void 0 : (_knowledgeBase$status2 = _knowledgeBase$status.value) === null || _knowledgeBase$status2 === void 0 ? void 0 : _knowledgeBase$status2.kbState) === _public.KnowledgeBaseState.READY;
  const {
    status,
    isLoading: isStatusLoading,
    installProductDoc,
    uninstallProductDoc
  } = productDoc;
  const onClickInstall = (0, _react.useCallback)(() => {
    if (!currentlyDeployedInferenceId) {
      throw new Error('Inference ID is required to install product documentation');
    }
    installProductDoc(currentlyDeployedInferenceId);
  }, [installProductDoc, currentlyDeployedInferenceId]);
  const onClickUninstall = (0, _react.useCallback)(() => {
    overlays.openConfirm(_i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.productDocUninstallConfirmText', {
      defaultMessage: `Are you sure you want to uninstall the Elastic documentation?`
    }), {
      title: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.productDocUninstallConfirmTitle', {
        defaultMessage: `Uninstalling Elastic documentation`
      })
    }).then(confirmed => {
      if (confirmed && currentlyDeployedInferenceId) {
        uninstallProductDoc(currentlyDeployedInferenceId);
      }
    });
  }, [overlays, uninstallProductDoc, currentlyDeployedInferenceId]);
  const buttonText = (0, _react.useMemo)(() => {
    if (!status || status === 'error' || !canInstallProductDoc) {
      return statusToButtonTextMap.uninstalled;
    }
    if (isStatusLoading && status !== 'installing' && status !== 'uninstalling') {
      return statusToButtonTextMap.loading;
    }
    return statusToButtonTextMap[status];
  }, [status, isStatusLoading, canInstallProductDoc]);
  const isLoading = isStatusLoading || status === 'installing' || status === 'uninstalling';
  const content = (0, _react.useMemo)(() => {
    if (status === 'installed') {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "flexStart",
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        textSize: "s",
        color: "success"
      }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.installProductDocInstalledLabel', {
        defaultMessage: 'Installed'
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "settingsTabUninstallProductDocButton",
        onClick: onClickUninstall,
        color: "warning"
      }, buttonText)));
    }
    const installButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "settingsTabInstallProductDocButton",
      onClick: onClickInstall,
      disabled: !canInstallProductDoc,
      isLoading: isLoading
    }, buttonText);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexStart",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, canInstallProductDoc ? installButton : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.installDissabledTooltip', {
        defaultMessage: 'Knowledge Base has to be installed first.'
      })
    }, installButton)));
  }, [canInstallProductDoc, onClickInstall, onClickUninstall, status, buttonText, isLoading]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.productDocLabel', {
      defaultMessage: 'Elastic documentation'
    })),
    description: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("em", null, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.techPreview', {
      defaultMessage: '[technical preview] '
    })), _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.productDocDescription', {
      defaultMessage: "Install Elastic documentation to improve the assistant's efficiency."
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, content));
}