"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChangeKbModel = ChangeKbModel;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _get_model_options_for_inference_endpoints = require("@kbn/ai-assistant/src/utils/get_model_options_for_inference_endpoints");
var _hooks = require("@kbn/ai-assistant/src/hooks");
var _public = require("@kbn/observability-ai-assistant-plugin/public");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ChangeKbModel({
  knowledgeBase,
  productDoc,
  currentlyDeployedInferenceId
}) {
  var _knowledgeBase$status, _knowledgeBase$status2, _knowledgeBase$status3, _knowledgeBase$status4, _knowledgeBase$status5, _knowledgeBase$status6, _knowledgeBase$status8, _knowledgeBase$status11, _knowledgeBase$status12, _knowledgeBase$status23, _knowledgeBase$status24, _knowledgeBase$status25, _knowledgeBase$status26, _knowledgeBase$status27, _knowledgeBase$status28, _knowledgeBase$status29;
  const {
    overlays
  } = (0, _public.useKibana)().services;
  const [hasLoadedCurrentModel, setHasLoadedCurrentModel] = (0, _react.useState)(false);
  const [isUpdatingModel, setIsUpdatingModel] = (0, _react.useState)(false);
  const {
    inferenceEndpoints,
    isLoading: isLoadingEndpoints,
    error
  } = (0, _hooks.useInferenceEndpoints)();
  const modelOptions = (0, _get_model_options_for_inference_endpoints.getModelOptionsForInferenceEndpoints)({
    endpoints: inferenceEndpoints
  });
  const [selectedInferenceId, setSelectedInferenceId] = (0, _react.useState)(currentlyDeployedInferenceId || '');
  const doesModelNeedRedeployment = ((_knowledgeBase$status = knowledgeBase.status) === null || _knowledgeBase$status === void 0 ? void 0 : (_knowledgeBase$status2 = _knowledgeBase$status.value) === null || _knowledgeBase$status2 === void 0 ? void 0 : _knowledgeBase$status2.kbState) === _public.KnowledgeBaseState.MODEL_PENDING_ALLOCATION || ((_knowledgeBase$status3 = knowledgeBase.status) === null || _knowledgeBase$status3 === void 0 ? void 0 : (_knowledgeBase$status4 = _knowledgeBase$status3.value) === null || _knowledgeBase$status4 === void 0 ? void 0 : _knowledgeBase$status4.kbState) === _public.KnowledgeBaseState.MODEL_PENDING_DEPLOYMENT;
  const isSelectedModelCurrentModel = selectedInferenceId === currentlyDeployedInferenceId;
  const isKnowledgeBaseInLoadingState = knowledgeBase.isInstalling || knowledgeBase.isWarmingUpModel || knowledgeBase.isPolling || ((_knowledgeBase$status5 = knowledgeBase.status) === null || _knowledgeBase$status5 === void 0 ? void 0 : (_knowledgeBase$status6 = _knowledgeBase$status5.value) === null || _knowledgeBase$status6 === void 0 ? void 0 : _knowledgeBase$status6.isReIndexing);
  (0, _react.useEffect)(() => {
    var _knowledgeBase$status7;
    if (!hasLoadedCurrentModel && modelOptions !== null && modelOptions !== void 0 && modelOptions.length && (_knowledgeBase$status7 = knowledgeBase.status) !== null && _knowledgeBase$status7 !== void 0 && _knowledgeBase$status7.value) {
      setSelectedInferenceId(currentlyDeployedInferenceId || modelOptions[0].key);
      setHasLoadedCurrentModel(true);
    }
  }, [hasLoadedCurrentModel, modelOptions, (_knowledgeBase$status8 = knowledgeBase.status) === null || _knowledgeBase$status8 === void 0 ? void 0 : _knowledgeBase$status8.value, setSelectedInferenceId, currentlyDeployedInferenceId]);
  (0, _react.useEffect)(() => {
    if (isUpdatingModel && !knowledgeBase.isInstalling && !knowledgeBase.isPolling) {
      setIsUpdatingModel(false);
    }
  }, [knowledgeBase.isInstalling, knowledgeBase.isPolling, isUpdatingModel]);
  const buttonText = (0, _react.useMemo)(() => {
    var _knowledgeBase$status9, _knowledgeBase$status10;
    if (((_knowledgeBase$status9 = knowledgeBase.status) === null || _knowledgeBase$status9 === void 0 ? void 0 : (_knowledgeBase$status10 = _knowledgeBase$status9.value) === null || _knowledgeBase$status10 === void 0 ? void 0 : _knowledgeBase$status10.kbState) === _public.KnowledgeBaseState.NOT_INSTALLED) {
      return _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBase.installModelLabel', {
        defaultMessage: 'Install'
      });
    }
    if (doesModelNeedRedeployment && isSelectedModelCurrentModel) {
      return _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBase.redeployModelLabel', {
        defaultMessage: 'Redeploy model'
      });
    }
    return _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBase.updateModelLabel', {
      defaultMessage: 'Update model'
    });
  }, [doesModelNeedRedeployment, isSelectedModelCurrentModel, (_knowledgeBase$status11 = knowledgeBase.status) === null || _knowledgeBase$status11 === void 0 ? void 0 : (_knowledgeBase$status12 = _knowledgeBase$status11.value) === null || _knowledgeBase$status12 === void 0 ? void 0 : _knowledgeBase$status12.kbState]);
  const confirmationMessages = (0, _react.useMemo)(() => ({
    title: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBase.updateModelConfirmTitle', {
      defaultMessage: 'Update Knowledge Base Model'
    }),
    message: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBase.updateModelConfirmMessage', {
      defaultMessage: 'This will re-index all knowledge base entries if there are any.'
    }),
    cancelButtonText: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBase.updateModelCancel', {
      defaultMessage: 'Cancel'
    })
  }), []);
  const handleInstall = (0, _react.useCallback)(() => {
    if (selectedInferenceId) {
      var _knowledgeBase$status13, _knowledgeBase$status14;
      if (((_knowledgeBase$status13 = knowledgeBase.status) === null || _knowledgeBase$status13 === void 0 ? void 0 : (_knowledgeBase$status14 = _knowledgeBase$status13.value) === null || _knowledgeBase$status14 === void 0 ? void 0 : _knowledgeBase$status14.kbState) === _public.KnowledgeBaseState.NOT_INSTALLED || doesModelNeedRedeployment && isSelectedModelCurrentModel) {
        setIsUpdatingModel(true);
        if (doesModelNeedRedeployment) {
          knowledgeBase.warmupModel(selectedInferenceId);
        } else {
          knowledgeBase.install(selectedInferenceId);
        }
      } else {
        overlays.openConfirm(confirmationMessages.message, {
          title: confirmationMessages.title,
          cancelButtonText: confirmationMessages.cancelButtonText,
          buttonColor: 'primary'
        }).then(isConfirmed => {
          if (isConfirmed) {
            setIsUpdatingModel(true);
            knowledgeBase.install(selectedInferenceId);
            productDoc.installProductDoc(selectedInferenceId);
          }
        });
      }
    }
  }, [selectedInferenceId, knowledgeBase, doesModelNeedRedeployment, isSelectedModelCurrentModel, overlays, confirmationMessages, productDoc]);
  const superSelectOptions = modelOptions.map(option => ({
    value: option.key,
    inputDisplay: option.label,
    dropdownDisplay: /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("strong", null, option.label), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      css: {
        marginTop: 4
      },
      "data-test-subj": `observabilityAiAssistantKnowledgeBaseModelDropdownOption-${option.label}`
    }, option.description))
  }));
  const content = (0, _react.useMemo)(() => {
    var _knowledgeBase$status15, _knowledgeBase$status16, _knowledgeBase$status17, _knowledgeBase$status18, _knowledgeBase$status19, _knowledgeBase$status20, _knowledgeBase$status21, _knowledgeBase$status22;
    if (error) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBase.errorLoadingModelsTitle', {
          defaultMessage: 'Error loading models'
        }),
        color: "danger",
        iconType: "alert"
      }, /*#__PURE__*/_react.default.createElement("p", null, error.message));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      css: {
        width: 354
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
      fullWidth: true,
      hasDividers: true,
      isLoading: isLoadingEndpoints,
      options: superSelectOptions,
      valueOfSelected: selectedInferenceId,
      onChange: value => setSelectedInferenceId(value),
      disabled: isKnowledgeBaseInLoadingState,
      "data-test-subj": "observabilityAiAssistantKnowledgeBaseModelDropdown"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      "data-test-subj": "observabilityAiAssistantKnowledgeBaseUpdateModelButton",
      onClick: handleInstall,
      isDisabled: !selectedInferenceId || isKnowledgeBaseInLoadingState || ((_knowledgeBase$status15 = knowledgeBase.status) === null || _knowledgeBase$status15 === void 0 ? void 0 : (_knowledgeBase$status16 = _knowledgeBase$status15.value) === null || _knowledgeBase$status16 === void 0 ? void 0 : (_knowledgeBase$status17 = _knowledgeBase$status16.endpoint) === null || _knowledgeBase$status17 === void 0 ? void 0 : _knowledgeBase$status17.inference_id) === _public.LEGACY_CUSTOM_INFERENCE_ID && selectedInferenceId === _public.ELSER_ON_ML_NODE_INFERENCE_ID || ((_knowledgeBase$status18 = knowledgeBase.status) === null || _knowledgeBase$status18 === void 0 ? void 0 : (_knowledgeBase$status19 = _knowledgeBase$status18.value) === null || _knowledgeBase$status19 === void 0 ? void 0 : _knowledgeBase$status19.kbState) !== _public.KnowledgeBaseState.NOT_INSTALLED && selectedInferenceId === ((_knowledgeBase$status20 = knowledgeBase.status) === null || _knowledgeBase$status20 === void 0 ? void 0 : (_knowledgeBase$status21 = _knowledgeBase$status20.value) === null || _knowledgeBase$status21 === void 0 ? void 0 : (_knowledgeBase$status22 = _knowledgeBase$status21.endpoint) === null || _knowledgeBase$status22 === void 0 ? void 0 : _knowledgeBase$status22.inference_id) && !doesModelNeedRedeployment
    }, buttonText)));
  }, [error, buttonText, isLoadingEndpoints, superSelectOptions, selectedInferenceId, setSelectedInferenceId, isKnowledgeBaseInLoadingState, doesModelNeedRedeployment, (_knowledgeBase$status23 = knowledgeBase.status) === null || _knowledgeBase$status23 === void 0 ? void 0 : (_knowledgeBase$status24 = _knowledgeBase$status23.value) === null || _knowledgeBase$status24 === void 0 ? void 0 : _knowledgeBase$status24.kbState, (_knowledgeBase$status25 = knowledgeBase.status) === null || _knowledgeBase$status25 === void 0 ? void 0 : (_knowledgeBase$status26 = _knowledgeBase$status25.value) === null || _knowledgeBase$status26 === void 0 ? void 0 : (_knowledgeBase$status27 = _knowledgeBase$status26.endpoint) === null || _knowledgeBase$status27 === void 0 ? void 0 : _knowledgeBase$status27.inference_id, handleInstall]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBase.chooseModelLabel', {
      defaultMessage: 'Set text embeddings model'
    })),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.knowledgeBase.chooseModelDescription', {
      defaultMessage: "Choose the default language model for the Assistant's responses."
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "observabilityAiAssistantManagementChangeKbModelLearnMoreLink",
      href: "https://www.elastic.co/docs/explore-analyze/machine-learning/nlp/ml-nlp-built-in-models",
      target: "_blank"
    }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBase.subtitleLearnMore', {
      defaultMessage: 'Learn more'
    }))), ((_knowledgeBase$status28 = knowledgeBase.status) === null || _knowledgeBase$status28 === void 0 ? void 0 : (_knowledgeBase$status29 = _knowledgeBase$status28.value) === null || _knowledgeBase$status29 === void 0 ? void 0 : _knowledgeBase$status29.kbState) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      css: {
        marginTop: 8
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBase.kbStateLabel', {
      defaultMessage: 'Knowledge Base Status:'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      "data-test-subj": "observabilityAiAssistantKnowledgeBaseStatus",
      color: knowledgeBase.status.value.kbState === _public.KnowledgeBaseState.READY ? isKnowledgeBaseInLoadingState ? 'warning' : 'success' : 'default'
    }, knowledgeBase.status.value.kbState === _public.KnowledgeBaseState.READY ? isKnowledgeBaseInLoadingState ? _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBase.stateUpdatingModel', {
      defaultMessage: 'Updating model'
    }) : _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBase.stateInstalled', {
      defaultMessage: 'Installed'
    }) : knowledgeBase.status.value.kbState)), isKnowledgeBaseInLoadingState && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "s",
      "data-test-subj": "observabilityAiAssistantKnowledgeBaseLoadingSpinner"
    }))))))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, content));
}