"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerVisualizeESQLFunction = registerVisualizeESQLFunction;
var _visualize_esql = require("@kbn/observability-ai-assistant-plugin/common/functions/visualize_esql");
var _common = require("@kbn/inference-plugin/common");
var _visualize_esql2 = require("../../common/functions/visualize_esql");
var _validate_esql_query = require("./query/validate_esql_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMessageForLLM = (intention, query, hasErrors) => {
  if (hasErrors) {
    return 'The query has syntax errors';
  }
  if (intention === _visualize_esql.VisualizeESQLUserIntention.executeAndReturnResults || intention === _visualize_esql.VisualizeESQLUserIntention.generateQueryOnly) {
    return 'These results are not visualized.';
  }

  // This message is added to avoid the model echoing the full ES|QL query back to the user.
  // The UI already shows the chart.
  return `Only the following query is visualized: \`\`\`esql\n' + ${query} + '\n\`\`\`\n
  If the query is visualized once, don't attempt to visualize the same query again immediately.
  After calling visualize_query you are done - **do NOT repeat the ES|QL query or add any further
  explanation unless the user explicitly asks for it again.** Mention that the query is visualized.`;
};
function registerVisualizeESQLFunction({
  functions,
  resources,
  signal
}) {
  functions.registerFunction(_visualize_esql2.visualizeESQLFunction, async ({
    arguments: {
      query,
      intention
    }
  }) => {
    // errorMessages contains the syntax errors from the client side valdation
    // error contains the error from the server side validation, it is always one error
    // and help us identify errors like index not found, field not found etc.

    const correctedQuery = (0, _common.correctCommonEsqlMistakes)(query).output;
    const {
      columns,
      errorMessages,
      rows,
      error
    } = await (0, _validate_esql_query.runAndValidateEsqlQuery)({
      query: correctedQuery,
      client: (await resources.context.core).elasticsearch.client.asCurrentUser,
      signal
    });
    const message = getMessageForLLM(intention, query, Boolean(errorMessages === null || errorMessages === void 0 ? void 0 : errorMessages.length));
    return {
      data: {
        columns: columns !== null && columns !== void 0 ? columns : [],
        rows: rows !== null && rows !== void 0 ? rows : [],
        correctedQuery
      },
      content: {
        message,
        errorMessages: [...(errorMessages ? errorMessages : []), ...(error ? [error.message] : [])]
      }
    };
  });
}