"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerNavigationEventTypes = registerNavigationEventTypes;
var _sharedUxChromeNavigation = require("@kbn/shared-ux-chrome-navigation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const fields = {
  [_sharedUxChromeNavigation.FieldType.ID]: {
    [_sharedUxChromeNavigation.FieldType.ID]: {
      type: 'keyword',
      _meta: {
        description: 'The ID of navigation node.'
      }
    }
  },
  [_sharedUxChromeNavigation.FieldType.HREF]: {
    [_sharedUxChromeNavigation.FieldType.HREF]: {
      type: 'keyword',
      _meta: {
        description: 'The href of the navigation node.',
        optional: true
      }
    }
  },
  [_sharedUxChromeNavigation.FieldType.HREF_PREV]: {
    [_sharedUxChromeNavigation.FieldType.HREF_PREV]: {
      type: 'keyword',
      _meta: {
        description: 'The previous href before clicking on a navigation node.',
        optional: true
      }
    }
  }
};
const eventTypes = [{
  eventType: _sharedUxChromeNavigation.EventType.CLICK_NAVLINK,
  schema: {
    ...fields[_sharedUxChromeNavigation.FieldType.ID],
    ...fields[_sharedUxChromeNavigation.FieldType.HREF],
    ...fields[_sharedUxChromeNavigation.FieldType.HREF_PREV]
  }
}];
function registerNavigationEventTypes(core) {
  const {
    analytics
  } = core;
  for (const eventType of eventTypes) {
    analytics.registerEventType(eventType);
  }
}