"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatProductName = formatProductName;
exports.getIdentifier = getIdentifier;
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NODE_IDENTIFIER_SINGULAR = _i18n.i18n.translate('xpack.monitoring.setupMode.node', {
  defaultMessage: `node`
});
const NODE_IDENTIFIER_PLURAL = _i18n.i18n.translate('xpack.monitoring.setupMode.nodes', {
  defaultMessage: `nodes`
});
const INSTANCE_IDENTIFIER_SINGULAR = _i18n.i18n.translate('xpack.monitoring.setupMode.instance', {
  defaultMessage: `instance`
});
const INSTANCE_IDENTIFIER_PLURAL = _i18n.i18n.translate('xpack.monitoring.setupMode.instances', {
  defaultMessage: `instances`
});
const SERVER_IDENTIFIER_SINGULAR = _i18n.i18n.translate('xpack.monitoring.setupMode.server', {
  defaultMessage: `server`
});
const SERVER_IDENTIFIER_PLURAL = _i18n.i18n.translate('xpack.monitoring.setupMode.servers', {
  defaultMessage: `servers`
});
function formatProductName(productName) {
  if (productName === _constants.APM_SYSTEM_ID) {
    return productName.toUpperCase();
  }
  return (0, _lodash.capitalize)(productName);
}
const PRODUCTS_THAT_USE_NODES = [_constants.LOGSTASH_SYSTEM_ID, _constants.ELASTICSEARCH_SYSTEM_ID];
const PRODUCTS_THAT_USE_INSTANCES = [_constants.KIBANA_SYSTEM_ID, _constants.BEATS_SYSTEM_ID];
function getIdentifier(productName, usePlural = false) {
  if (PRODUCTS_THAT_USE_INSTANCES.includes(productName)) {
    return usePlural ? INSTANCE_IDENTIFIER_PLURAL : INSTANCE_IDENTIFIER_SINGULAR;
  }
  if (PRODUCTS_THAT_USE_NODES.includes(productName)) {
    return usePlural ? NODE_IDENTIFIER_PLURAL : NODE_IDENTIFIER_SINGULAR;
  }
  if (productName === _constants.APM_SYSTEM_ID) {
    return usePlural ? SERVER_IDENTIFIER_PLURAL : SERVER_IDENTIFIER_SINGULAR;
  }
  return productName;
}